#include "ShaderCommon.fx"

Texture2D<float4> Tex;

float4 IntroPS(FullScreenVertexOut input) : SV_Target
{
	float2 uv = input.uv;
	float a = 0.2f;
	float b = 0.8f;

	uv.y = saturate(uv.y - a) / (b-a);		// Map between 0.2f and 0.8f
	uv.y = uv.y > b ? 0.0f : uv.y;

	float3 color = Tex.Sample(BilinearClampSampler, uv).xyz;
	return float4(color, ExtraParams.x);
}