#include "ShaderCommon.fx"

Texture2D<float4> NormalMap;

DefaultVertexOut CreditGlassVS(DefaultVertexIn input)
{
	DefaultVertexOut output = (DefaultVertexOut)0;
	output.position = mul( mul( mul(input.position, World), View), Projection);
	output.wpos = mul(float4(input.position.xyz, 1.0f), World);
	output.color = input.color;
	output.normal = input.normal;
	output.uv = input.uv;
	return output;
}

float4 CreditGlassPS(DefaultVertexOut input) : SV_Target
{
	float3 textCol = NormalMap.Sample(BilinearClampSampler, input.uv) * 2.0f - 1.0f;

	float4 col = input.color;
	col.xyz += renderDirectionalLight(directionalLights[0], input.position.xyz, input.normal);

	return float4(col.xyz + textCol, 0.2f);
}

float4 NormalMappedLightingPS(DefaultVertexOut input) : SV_Target
{
	float3 normalMap = NormalMap.Sample(BilinearWrapSampler, input.uv).xyz;
	normalMap = normalMap * 2.0f - 1.0f;

	// Ensure tangent is orthogonal
	input.tangent = normalize(input.tangent - dot(input.tangent, input.normal) * input.normal);

	// Create binormal
	float3 binormal = cross(input.normal, input.tangent);

	// Create TBN matrix
	float3x3 tbn = float3x3(input.tangent, binormal, input.normal);
	
	input.normal = normalize(mul(normalMap, tbn));

	// Do lighting here

	return float4(input.normal * 0.5f + 0.5f, 1.0f);
}