#include "ShaderCommon.fx"

Texture2D<float4> Tex;

DefaultVertexOut BasicVS(DefaultVertexIn input)
{
	DefaultVertexOut output = (DefaultVertexOut)0;
	output.position = mul( mul( mul(input.position, World), View), Projection);
	output.wpos = mul(float4(input.position.xyz, 1.0f), World);
	output.color = input.color;
	output.normal = input.normal;
	output.uv = input.uv;
	return output;
}

float4 ForwardLitPS(DefaultVertexOut input) : SV_Target
{
	float3 color = float3(0.0f, 0.0f, 0.0f);
	float3 normal = input.normal; 
	float3 baseColor = input.color.xyz;

	[unroll]
	for(int j = 0; j < 2; ++j)
	{
		color += renderDirectionalLight(directionalLights[j], input.wpos.xyz, normal);
	}

	color += float3(0.01f, 0.01f, 0.01f);
	//color = input.normal * 0.5f + 0.5f;

	return float4(color, ExtraParams.x);
}

float4 ForwardTexturedLitPS(DefaultVertexOut input) : SV_Target
{
	float3 color = float3(0.0f, 0.0f, 0.0f);
	float3 normal = input.normal;
	float3 baseColor = Tex.Sample(BilinearWrapSampler, input.uv).xyz;

	[unroll]
	for(int j = 0; j < MAX_DIRECTIONAL_LIGHTS; ++j)
	{
		color += renderDirectionalLight(directionalLights[j], input.wpos.xyz, normal);
	}

	return float4(color, ExtraParams.x);
}

float4 ForwardTexturedUnlitPS(DefaultVertexOut input) : SV_Target
{
	float3 color = Tex.Sample(BilinearWrapSampler, input.uv).xyz;
	return float4(color, ExtraParams.x);
}

float4 FullScreenTexturedPS(FullScreenVertexOut input) : SV_Target
{
	float3 color = Tex.Sample(BilinearWrapSampler, input.uv).xyz;
	return float4(color, ExtraParams.x);
}