#include "inc/uniforms.glsl"
#include "inc/utils.glsl"

uniform vec4 stars_color;
uniform float stars_color_offset;

#line 3 1

#ifdef VERTEX
#line 1 4
#include "inc/geometry_io.vs"
flat out int ex_gl_InstanceID;

#line 10 1
void process() 
{
	float j=float(gl_InstanceID);
	vec3 pos=vec3(
			noise(vec3(j,j*j*0.025,sqrt(j)*0.03)),
			noise(vec3(j*2,j*j*0.0315,sqrt(j*j*j*5)*0.01231)),
			noise(vec3(j*j*0.012,j*0.0531,sqrt(j*j)*0.022))
					);
	pos=(pos-0.5)*70.;
	if(length(pos)<16.)pos*=3.2;
	vec4 offset =(modelView)*(vec4(pos,1.));
	float scale = length(modelView*(vec4(pos,0.)+vec4(1.))-offset)*2.;
	ex_Position = in_Position*scale+offset;
	ex_Position.w=1;
	gl_Position = (projectionMatrix)*ex_Position;
	
	ex_gl_InstanceID=gl_InstanceID;
	
	ex_UV = in_UV;
}

#define PROCESSING_FUNCTION process
#line 1 5
#include "inc/geometry.vs"

#endif


#ifdef FRAGMENT
#line 1 6
in vec4 ex_Color;
smooth in vec3 ex_Normal; 
smooth in vec2 ex_UV;
in vec4 ex_Position; //viewspace

flat in int ex_gl_InstanceID;

layout(location = 0) out vec4 out_Color;

uniform sampler2D tex;
#line 1 7
void main()
{
	vec3 l=vec3(0.);
	for(int i=0;i<10;i++){
		float j=i+ex_gl_InstanceID;
		j*=0.003;
		vec2 pos=vec2(
					noise(vec3(j,j*j*0.5,sqrt(j))),
					noise(vec3(j*2,j*j*1.5,sqrt(j*j*j)))
					
					);
		pos=(pos-0.5)*0.5+0.5;
		float phase=noise(vec3(j*j*1.1));
		pos.y+=sin(p_time*0.1+phase*2331.43+100.)*0.15;
		float d=length(pos-ex_UV);
		float c=max(0,noise(vec3(j*0.2))*0.000000005/(d*d*d*d)-0.01);
		vec3 col=stars_color.xyz*c;
		vec3 hsv=rgb2hsv(col);
		l+=hsv2rgb(hsv+vec3(stars_color_offset*sin((i*10.+ex_gl_InstanceID)*101.2),0.,0.));
	}
	
	float limit = 1.5;
	out_Color = vec4(min(limit,l.x),min(limit,l.y),min(limit,l.z),0.5)*max(0,1-1/length(ex_Position.xyz*5));
}
#endif
