#include "inc/uniforms.glsl"
#include "inc/utils.glsl"

uniform vec4 stars_color;
uniform float stars_color_offset;

#line 3 1

#ifdef VERTEX
#line 1 4
#include "inc/geometry_io.vs"

float slnoise(float a, float s) {
	return fract(299.1*cos(1984.9 + s*199.1*a));
}

uniform float p_jpeg, p_radial_blur;

#line 10 1
void process() 
{
	float j=float(gl_InstanceID);
	float t = p_time*3.0;
	vec3 pos=vec3(in_Position.x*1.2+2.0*slnoise(j,.9)-50.0+mod(t*20.0+slnoise(j,1.1)*100.0, 100.0), 1.0-2.0*slnoise(j, 1.3), 1.0-2.0*slnoise(j, 1.5));
	pos.yz = normalize(pos.yz)*(slnoise(j,1.7)*5.0+5.0*clamp(1.0-.01*pow(abs(pos.x*.2),2.0), .0, 1.0))+.08*(-p_jpeg+p_radial_blur)*vec2(slnoise(j+t, 2.1), slnoise(j+t, 2.3));
pos = pos.zyx;
	ex_Position.xyz = pos;
	ex_Position.w=1;
	gl_Position = (modelViewProject)*ex_Position;
	
	ex_UV = in_UV;
}

#define PROCESSING_FUNCTION process
#line 1 5
#include "inc/geometry.vs"

#endif


#ifdef FRAGMENT
#line 1 6
in vec4 ex_Color;
smooth in vec3 ex_Normal; 
smooth in vec2 ex_UV;
in vec4 ex_Position; //viewspace


layout(location = 0) out vec4 out_Color;

#line 1 7
void main()
{
	out_Color = vec4(.2, .1, .1, 1.0);
}
#endif
