#include "inc/uniforms.glsl"
#include "inc/utils.glsl"
#line 4 1

#ifdef VERTEX
#include "inc/geometry_io.vs"

#define pi (3.141592653589)

uniform float p_pulse_amp;

void process() 
{
	vec4 p = in_Position;
	float alpha = pow(abs(sin(p_beat*pi*0.5-pi*0.5)), 2.0)*0.3*p_pulse_amp;
	mat2x2 rot = mat2(cos(alpha), sin(alpha), -sin(alpha), cos(alpha));
	float len = length(p.xz);
	float len2 = sqrt(len);
	//float ring = max(0.0, sin(p.y*1.0 + p_beat*0.5)*10.0);
	//p *= 1.0 + ring;
	p.xz = rot*p.xz;
	
	p.xz *= 1.0-fract(p_beat)*0.2 * p_pulse_amp;
	ex_UV = in_UV*3.0 + vec2(0.0, p_beat*0.03);
	
	vec3 c = vec3(1.0, 1.0, 1.0);
	ex_Color = vec4(c, 1.0);
	
	ex_Position = (modelView)*p;
	gl_Position = (modelViewProject)*p;
}

#define PROCESSING_FUNCTION process
#include "inc/geometry.vs"

#endif

 
#ifdef FRAGMENT
#include "inc/geometry_io.fs"
#define pi (3.141592653589)
uniform vec4 diffuseColor;
uniform vec4 specularColor;
uniform float colorBoost;
uniform float roughness;
uniform float metallic;

uniform vec4 fogColor;
uniform float fogExponent;

void main()
{
	vec3 V = normalize(-ex_Position.xyz);
	vec3 N = ex_Normal.xyz; // viewspace normal
	#include "inc/cooktorrance.inc"
	
	final.rgb *= ex_Color.rgb;
	
	float dist = gl_FragCoord.z;
	final.rgb = mix(final.rgb, mix(final.rgb, fogColor.rgb, fogColor.a), min(1.0, pow(dist, fogExponent)));
	
	out_Color = vec4(final.rgb, 1.0);
}

#endif
