#include "inc/uniforms.glsl"
#include "inc/utils.glsl"

#ifdef VERTEX

layout(location=0) in vec4 in_Position;
layout(location=1) in vec4 in_Color;
// normal
layout(location=3) in vec2 in_UV;
out vec4 ex_Color;
out vec2 ex_UV;

uniform mat4x4 overlayTransform;

void main()
{
	ex_Color = in_Color;
	ex_UV = in_UV;
	gl_Position = overlayTransform*in_Position; 
}

#endif

#ifdef FRAGMENT

in vec4 ex_Color;
in vec2 ex_UV;

layout(location=0) out vec4 out_Color;

//uniform float p_overlay_alpha;
uniform float overlayAlpha;
uniform sampler2D tex;
uniform float overlayHue;
#line 36 2
void main()
{
	vec4 col = texture(tex, ex_UV);
	vec3 hsv = rgb2hsv(col.rgb);
	col.rgb = hsv2rgb(hsv + vec3(overlayHue, 0.0, 0.0));
	col.rgb *= 1.5; // vrikorjaus tekee vhn liian tummaa kamaa
	//col.rgb = pow(col.rgb, vec3(1.0/2.0));
	//col.a *= p_overlay_alpha;
	col.a *= overlayAlpha;
	out_Color = col;
} 

#endif