#include "inc/uniforms.glsl"
#include "inc/utils.glsl"

uniform vec4 neb_color;
uniform float p_neb_structs;
uniform float neb_color_offset;
uniform float neb_brightness;

#line 3 1

#ifdef VERTEX
#line 1 4
#include "inc/geometry_io.vs"

#line 10 1
void process() 
{
	ex_Position = (modelView)*in_Position;
	gl_Position = (modelViewProject)*in_Position;
	
	ex_UV = in_UV;
	
	ex_Normal = normalize((transpose(inverse(modelView))*vec4(in_Normal,1.)).xyz);
}

#define PROCESSING_FUNCTION process
#line 1 5
#include "inc/geometry.vs"

#endif


#ifdef FRAGMENT
#line 1 6
in vec4 ex_Color;
smooth in vec3 ex_Normal; 
smooth in vec2 ex_UV;
in vec4 ex_Position; //viewspace

layout(location = 0) out vec4 out_Color;

uniform sampler2D tex;
#line 1 7
void main()
{
	vec2 uv_center=(ex_UV-0.5)*2.;
	float vis=dot(ex_Normal,normalize(ex_Position.xyz));
	float mult = abs(vis*vis)+p_neb_structs; //not complete fading, adds some feeling of structure, try bigger values too!
	mult*=mult;
	//fade edges and hide near clipping
	mult*=max(0,1-length(uv_center*uv_center))*max(0,1-1/length(ex_Position.xyz*5));
	
	vec3 hsv=rgb2hsv(neb_color.rgb);
	
	out_Color = vec4(hsv2rgb(hsv+vec3(neb_color_offset,0.,0.)),neb_brightness)*mult*texture(tex,ex_UV.xy);  
}
#endif

