#include "inc/uniforms.glsl"
#include "inc/utils.glsl"
#line 3

#ifdef VERTEX

layout(location = 0) in vec4 in_Position;
layout(location = 1) in vec4 in_Color;
// normal
layout(location = 3) in vec2 in_UV;
out vec4 ex_Color;
out vec2 ex_UV;

void main()
{
	ex_Color = in_Color;
	ex_UV = in_UV;
	gl_Position = in_Position;
}

#endif

#ifdef FRAGMENT

in vec4 ex_Color;
in vec2 ex_UV;

layout(location = 0) out vec4 out_Color;

uniform sampler2D buffew;

void main()
{
	vec2 resolution = textureSize(buffew, 0);
	vec2 local = vec2(ivec2(gl_FragCoord.xy) % 8);
	vec2 base = gl_FragCoord.xy - local;
	vec3 result = vec3(.0);
	float u = local.x, v = local.y;
	for (float x = .0; x < 8.0; x += 1.0) {
		float cos_x = cos((2.0*x + 1.0)*u*3.141592 / 16.0);
		for (float y = .0; y < 8.0; y += 1.0) {
			float cos_y = cos((2.0 * y + 1.0)*v*3.141592 / 16.0);
			result += (texture(buffew, (base + vec2(x, y)) / resolution).xyz)*cos_x*cos_y;
		}
	}
	result *= .25;
	if (u < .5) result *= 1.0 / sqrt(2.0);
	if (v < .5) result *= 1.0 / sqrt(2.0);
	out_Color = vec4(result, 1.0);
}

#endif