
struct Light {
	vec3 pos;	
	vec3 intensity;
	vec3 dir;
	bool enabled;
	float falloff;
};

struct Screen
{
	vec2 size;
};

struct Camera
{
	vec3 pos;
	vec3 dir;
	float aspect;
	float near;
	float far;
};

uniform Screen screen;
uniform Camera scenecam;

uniform float p_time;
uniform float p_beat;

uniform mat3 NORMALX;

layout(std140) uniform TransformMatrices
{
	mat4 viewMatrix;
	mat4 projectionMatrix;
	mat4 inverseViewMatrix;
	mat4 inverseProjectionMatrix;
	mat4 viewProjectMatrix;
	mat4 modelViewProject;
	mat4 modelView;
	mat4 modelMatrix;
	mat3 normalMatrix;
	vec4 _unused;
	mat4 inverseModelView;
};

layout(std140) uniform LightArray
{
	Light spot[4];	
} lights;

#define MAX_LIGHTS (4)
// the index of the spotlight that casts shadows
#define SHADOW_SPOT_INDEX (0)
