uniform float u_begin;
uniform float u_skene;
uniform float u_sunheight;
uniform float u_logo;
float ft;

//pöllitty!
void rX(inout vec3 p, float a) 
{
    float c,s;
	vec3 q=p;
    c = cos(a); s = sin(a);
    p.y = c * q.y - s * q.z;
    p.z = s * q.y + c * q.z;
}

//pöllitty!
void rY(inout vec3 p, float a)
{
    float c,s;
	vec3 q=p;
    c = cos(a); s = sin(a);
    p.x = c * q.x + s * q.z;
    p.z = -s * q.x + c * q.z;
}

//pöllitty!
void rZ(inout vec3 p, float a) {
    float c,s;
	vec3 q=p;
    c = cos(a); s = sin(a);
    p.x = c * q.x - s * q.y;
    p.y = s * q.x + c * q.y;
}

vec2 heightmap_uv(vec3 pos)
{
	vec2 tuv = (pos.xz / 100.0) - vec2(0.5);
	return tuv;
}

vec3 gballpos = vec3(-100.0);

float dist(in vec3 pos, out float mat)
{
	vec2 tuv = heightmap_uv(pos);

	vec4 tc = texture2D(iChannel0, tuv);

	float lh = tc.r * 10.0;

	float m1 = 0.5 + sin(pos.x * 0.03) * 0.5;
	float m2 = 0.5 + sin(pos.z * 0.07) * 0.5;
	lh += mix(sin(pos.x * 0.1), sin(pos.x * 0.3), m2) * 0.2;
	lh += mix(sin(pos.z * 0.15), sin(pos.z * 0.277), m1) * 0.2;

	float d = max(pos.y - lh, 0.0);

	mat = 1.0;

#if 1
	float sphd = length(pos - gballpos) - 0.2;
	if (sphd < d)
	{
		mat = 2.0;
		d = sphd;
	}
#endif

	return d;
}

vec3 normal(vec3 p) 
{
	vec3 e = vec3(0.2, 0.0, 0.0);
	vec3 n;
	float uf;
	n.x = dist(p + e.xyy,uf) - dist(p - e.xyy,uf);
	n.y = dist(p + e.yxy,uf) - dist(p - e.yxy,uf);
	n.z = dist(p + e.yyx,uf) - dist(p - e.yyx,uf);
	return normalize(n);
}

vec2 cloudstex(vec3 d)
{
	float t = 0.0;
	float ang = atan(d.x, d.z) / (3.14159265359 * 2.0);
//	t += sin(ang * 100.0);
//	t += sin(d.y * 100.0);
	return texture2D(iChannel2, vec2(ang * 2.0, uv.y * 1.0)).rg;
}


float pdeter = 0.0f;
mat3 rotmtx_inv;

vec3 ro, rd, rd_camspace, rp;
float rl;
vec3 g_col;

float sprbright;

void sprite(in vec3 sprite_org, in vec4 size, in vec4 uv_coords)
{
	vec3 toobj = ro - sprite_org;

	if (length(toobj) > 200.0)
		return;

	toobj = rotmtx_inv * toobj;

	float pd = -toobj.z / pdeter;
	if (pd > 0.001)
	{
		vec2 ouv = (toobj.xy + rd_camspace.xy * pd + size.zw) / size.xy;
		bool insidesprite = ouv.x < 1.0 && ouv.x > 0.0 && ouv.y > 0.0 && ouv.y < 1.0;
		if (pd < rl && insidesprite)
		{
			ouv.y = mod(1.0-ouv.y, 1.0);
			ouv = uv_coords.xy + ouv * uv_coords.zw;

			vec4 spritedata = texture2D(iChannel3, ouv);
			if (spritedata.a > 0.99)
			{

				rp = ro + rd * pd;
				rl = pd;
//				col = spritedata.rgb;

			}
			g_col = mix(g_col, spritedata.rgb * sprbright, spritedata.a);
		}
	}

}


float sunheight;
vec3 aurinko;

void gsprite(in vec3 sprite_org, in vec4 size)
{
	vec3 toobj = ro - sprite_org;

	if (length(toobj) > 200.0)
		return;

	toobj = rotmtx_inv * toobj;

	float pd = -toobj.z / pdeter;
	if (pd > 0.001)
	{
		vec2 ouv = (toobj.xy + rd_camspace.xy * pd + size.zw) / size.xy;
		bool insidesprite = ouv.x < 1.0 && ouv.x > 0.0 && ouv.y > 0.0 && ouv.y < 1.0;
		if (insidesprite)
		{
			ouv.y = mod(1.0-ouv.y, 1.0);


			float ftime = max(ft - 1.0, 0.0); //loor(max(0.0, ft - 1.0))
			float fr = min(floor(ftime * 25.0), 127.0);
			vec2 fuv;
			fuv.y = floor(fr / 16.0);
			fuv.x = mod(fr, 16.0);

			ouv = (fuv + ouv) / vec2(16.0, 8.0);

			vec4 spritedata = texture2D(iChannel5, ouv);
			if (spritedata.a > 0.99)
			{

				rp = ro + rd * pd;
				rl = pd;
//				col = spritedata.rgb;

				vec3 n = normalize(spritedata.rbg - vec3(0.5));

//	rY(n, (-fr+4.0) * 3.14159265359 / 8.0);

				vec3 ld = normalize(vec3(0.0, 0.3, 1.0));

				float diffuse = pow(clamp(dot(ld, n), 0.0, 1.0), 2.0) + 0.2;
				spritedata.rgb = vec3(0.7, 0.7, 0.8) * diffuse;

//				spritedata.rgb = n*0.5+vec3(0.5);

				vec3 rrd = reflect(rd, n);

				float reflec = pow(clamp(dot(rrd, n), 0.0, 1.0), 37.0);
				spritedata.rgb += vec3(1.0) * reflec;

//				spritedata.rgb += trac(rd).rgb * diffuse * 0.3;

				g_col = mix(g_col, spritedata.rgb, spritedata.a);

			}
//			g_col = mix(g_col, spritedata.rgb * sprbright, spritedata.a);

			spritedata = texture2D(iChannel4, ouv);
			g_col = mix(g_col, spritedata.rgb * sprbright, spritedata.a);

		}
	}

}

vec3 clouds(vec3 pos, vec3 dir)
{
	vec3 aurinkodir = normalize(aurinko - pos);

	float suna = pow(clamp(dot(aurinkodir, dir), 0.0, 1.0), 37.0);

	vec3 col;

	col.bgr = vec3(0.5,0.2,0.1) + vec3(1.5, 0.7, 0.3) * dir.y;
	col = max(col, vec3(0.0));

	float sunmul = smoothstep(0.3, -0.5, sunheight);
	// sunmul = 1.0 if sun is down, 0.0 when it's up

	col = mix(col, vec3(0.6, 0.2, 0.0), sunmul * 0.6);

	vec2 csmp = cloudstex(dir);

	vec3 sunc = mix(vec3(1.0), vec3(0.5,0.4,0.0), sunmul*1.5-0.3);
	sunc += vec3(1.0, 0.7, 0.5) * csmp.g * sunmul;

	col = mix(col, sunc, csmp.r);
// TODO BETTER SUN SHADING SHIT
//	col = mix(col, mix(vec3(1.0), vec3(1.0,0.8,0.0), sunmul*3.0-0.3), csmp.g);


	col += vec3(1.0, 1.0, 0.3) * suna * 1.0;

	return col;
}

mat3 rot_x(float ang) { return mat3(
			1.0, 0.0, 0.0,
			0.0, cos(ang), -sin(ang),
			0.0, sin(ang), cos(ang)); }
mat3 rot_y(float ang){ return mat3(
			cos(ang), 0.0, -sin(ang),
			0.0,      1.0, 0.0,
			sin(ang), 0.0, cos(ang)); }
mat3 rot_z(float ang) { return mat3(
			cos(ang), -sin(ang), 0.0,
			sin(ang), cos(ang), 0.0,
			0.0, 0.0, 1.0); }

mat3 rot_inv(mat3 orig)
{
	return mat3(orig[0].x, orig[1].x, orig[2].x,
				orig[0].y, orig[1].y, orig[2].y,
				orig[0].z, orig[1].z, orig[2].z);
}

void paska_ao(vec3 pos, float aofo)
{
	g_col *= min(length(rp - pos) * aofo + 0.3, 1.0);
}

void logo()
{
	vec2 lp = vec2(-1.2, -0.5);
	vec2 p = (uv2-lp)/vec2(1.5,0.6);


	if (p.x < 0.0 || p.y < 0.0 || p.x > 1.0 || p.y > 1.0)
		return;

	p = mix(vec2(0.0,0.99), vec2(0.5, 0.82), p);

	vec4 immerse = texture2D(iChannel3, p);
//	g_col = vec3(0.0);
	g_col = mix(g_col, immerse.rgb, immerse.a * u_logo);
}


vec4 function()
{
	ft = motionblur(2.0) - u_begin;
	rd_camspace = normalize(vec3(uv2, 2.0));
	ro = vec3(0.0, 6.0, -15.0);

	float cd = 2.0 + sin(ft * 0.7) * 1.0;

	mat3 rotmtx;


	if (u_skene < 0.5)
	{
		ro.y = 10.0;
		ro.x = sin(ft) * 15.0;
		ro.z = -200.0+ft * 20.3;
		rotmtx = rot_y(ft * 0.1323) * rot_x(-0.2);
	}
	else if (u_skene < 1.5)
	{
		ro.y = 10.0;
		ro.x = sin(ft) * 15.0;
		ro.z = -19.51+ft * 20.3;
		rotmtx = rot_y(ft * 0.1999 + 0.0) * rot_x(-0.0);
	}
	else if (u_skene < 2.5)
	{
		ro.y = 10.0;
		ro.x = ft * 10.5;
		ro.z = 200.0f + ft;
		rotmtx = rot_y(-2.0);
	}
	else if (u_skene < 3.5)
	{
		ro.y = 20.f + sin(ft) * 10.f;
		ro.x = -ft * 10.0;
		ro.z = -00.0+ft * 20.3;
		rotmtx = rot_y(2.8+ft * 0.0323) * rot_x(-0.2);
	}
	else if (u_skene < 4.5)
	{
		ro.x = 0.0 - cos(ft*1.3) * 25.0 * cd;
		ro.y += 25.0 - cos(ft * 0.3553) * 25.0;
		ro.z = 0.0 + sin(ft*1.3) * 25.0 * cd;
		rotmtx = rot_y(ft * 1.3+3.14159*0.5) * rot_x(ro.y / -40.0);
	}
	else if (u_skene < 5.5)
	{
		ro = vec3(-8.0, 11.0+sin(ft*0.821)*0.2, 49.5 + sin(ft) * 0.0-ft*0.0);
		rotmtx = rot_y(3.0);

		gballpos = vec3(-9.0, 3.8, 29.0);
		const float hittime = (4.0*16.0+9.0)/25.0 + 1.0;
		if (ft > hittime)
		{
			float flyt = ft - hittime;
			gballpos += vec3(0.0, 35.0, -55.0) * flyt + vec3(0.0, -6.0, 0.0) * flyt * flyt;

			float shake = max(0.0, 1.0 - flyt);
			rd_camspace.xy += sin(ft * vec2(37.4, 39.51)) * shake * 0.02;

		}
	}

//	ro.y = texture2D(iChannel0, heightmap_uv(ro)).r * 10.0 + 1.0;


	pdeter = dot(vec3(0.0, 0.0, 1.0), rd_camspace);


	rotmtx_inv = rot_inv(rotmtx);


	rd = rotmtx * rd_camspace;
	vec3 ray_z = rotmtx * vec3(0.0, 0.0, 1.0);
	vec3 ray_x = rotmtx * vec3(1.0, 0.0, 0.0);
	vec3 ray_y = rotmtx * vec3(0.0, 1.0, 0.0);



	rp = ro;
	rl = 0.0;

	float mat = 0.0;
	g_col = vec3(0.0);


//	float godray = 1.0;

//	sunheight = sin(ft) * 1.0; //min(-0.5 + ft * 0.1, 0.6);
//	sunheight = 0.6;
	sunheight = u_sunheight;
	aurinko = normalize(vec3(0.0, sunheight, -1.0)) * 10000.0;

	sprbright = smoothstep(-0.0, 0.3, sunheight) + 0.1;


	for (int i = 0; i < 256; i++)
	{
		float d;
		float matn;


		d = dist(rp, matn);

//		d = min(1.0, d);

//		float cloudaccu = clouds(normalize(aurinko - rp));
//		godray -= 0.02 * d * cloudaccu;

		if (d < 0.1)
		{
			mat = matn;
			break;
		}
		if (rl > 200.0)
			break;

		rp += rd * d * 0.8;
		rl += d * 0.8;

	}

//	bool radiator = sin(length(ppos-sprite_org) * 1.0 - 7.0*ft) < 0.0;


	if (mat > 1.5)
	{
		vec3 n = normal(rp);
		float valo = clamp(dot(vec3(0.0, 0.0, 1.0), n), 0.1, 1.0);
		g_col = vec3(valo);// * (1.0 - clouds(aurinkodir) * 0.1);

	}
	else if (mat > 0.5)
	{

		vec3 n = normal(rp);
//		g_col = vec3(0.5) + n;

		g_col = texture2D(iChannel1, heightmap_uv(rp)).rgb;

		vec3 aurinkodir = normalize(aurinko - rp);

		float valo = clamp(dot(aurinkodir, n), 0.1, 1.0);
		g_col *= vec3(valo);// * (1.0 - clouds(aurinkodir) * 0.1);
		g_col *= 1.3;


//		g_col *= 1.0 - rl/200.0;
	}
	else
	{
		g_col = clouds(ro, rd);

//		col = mix(vec3(0.0), vec3(0.6, 0.2, 0.0), 0.3 - max(sunheight, 0.0) * 0.3);

	}

//	col = mix(col, vec3(1.0, 0.9, 0.8), clamp(godray * 0.2, 0.0, 0.4));

	const vec2 s_gfxreso = vec2(1024.0);
const vec4 s_GOLFCADDY = vec4(2.,2. ,  220.,194.) / s_gfxreso.xyxy;
const vec4 s_WHITEFLG = vec4(265.,5.,  45.,230.) / s_gfxreso.xyxy;
const vec4 s_BLUEFLAG = vec4(365.,5.,  45.,230.) / s_gfxreso.xyxy;
const vec4 s_RED_FLAG = vec4(447.,6.,  45.,230.) / s_gfxreso.xyxy;
const vec4 s_LEFTGUY = vec4(526.,27.,  118.,364.) / s_gfxreso.xyxy;
const vec4 s_MID_GUY = vec4(670.,37.,  116.,357.) / s_gfxreso.xyxy;
const vec4 s_RIGHTGUY = vec4(816.,47.,    102.,333.) / s_gfxreso.xyxy;
const vec4 s_TREE = vec4(4.,231.,   231.,242.) / s_gfxreso.xyxy;
const vec4 s_SHRUBBERY = vec4(8.,507.,   251.,233.) / s_gfxreso.xyxy;
const vec4 s_PALMTREE = vec4(284.,410.,   251.,373.) / s_gfxreso.xyxy;
const vec4 s_HACKERS = vec4(624.,442.,  240.,53.) / s_gfxreso.xyxy;
const vec4 s_S_DIAMOND = vec4(39.,808.,   217.,176.) / s_gfxreso.xyxy;
const vec4 s_XL_DIAMOND = vec4(574.,564.,  450.,460.) / s_gfxreso.xyxy;

/*GOLFCADDY - 2,2   220x194
WHITEFLG - 265,5  45,230
BLUEFLAG - 365,5  45x230
RED_FLAG - 447,6  45x230
LEFTGUY - 526,27  118x364
MID_GUY - 670,37  116x357
RIGHTGUY - 816,47    102x333
TREE - 4,231   231x242
SHRUBBERY - 8,507   257x233
PALMTREE - 284,410   251x373
HACKERS - 624,442  240x53
S_DIAMOND - 39,808   217x176
XL_DIAMOND - 574,564  450x460*/

#if 1
	vec2 tilescale = vec2(30.0);
	vec2 tilenum = floor(ro.xz / tilescale);

	for (float tx = -6.0; tx < 6.0; tx++)
	{
		for (float ty = -6.0; ty < 6.0; ty++)
		{
			vec2 tileidx = tilenum + vec2(tx,ty);

//			if (dot(rd.zx, vec2(tileidx)*tilescale) < 0.0)
//				continue;

			vec3 p1;
			vec2 randomizer = sin(tileidx * vec2(16.523, 15.11234)) * 0.2;
			randomizer += cos(tileidx * vec2(11.3991, 12.3212)) * 0.3;
			p1.xz = (tileidx + randomizer) * tilescale;
			p1.y = texture2D(iChannel0, heightmap_uv(p1)).r * 10.0;
			float type = sin(dot(tileidx, vec2(10.412123, 20.6669123)));
			float downer = 0.05+0.05*sin(dot(tileidx, vec2(3.412, 9.666)));
			vec4 sscale = vec4(0.0);
			vec4 sdef = vec4(0.0);

			float aofo = 0.3;
			if (type < -0.6)
			{
				sscale = vec4(10.0,15.0, 5.7, 0.4 + downer);
				sdef = s_PALMTREE;
				aofo = 0.5;
			}
			else if (type < 0.3)
			{
				sscale = vec4(5.0,5.0, 2.5, 0.3+ downer);
				sdef = s_TREE;
			}
			else
			{
				sscale = vec4(5.0,5.0, 2.5, 0.3 + downer);
				sdef = s_SHRUBBERY;
			}

			paska_ao(p1, aofo);
			sprite(p1, sscale, sdef);
		}
	}

	sprite(vec3(5.5, 4.0, -27.9), vec4(2.0,5.0, 1.0, 1.0), s_RED_FLAG);

	sprite(vec3(15.5, 5.0, 29.5), vec4(8.0,6.0, 1.5, 2.0), s_GOLFCADDY);


	const vec3 g1 = vec3(5.5, 3.5, 27.5);
	const vec3 g2 = vec3(0.5, 3.5, 29.5);
	const vec3 g3 = vec3(-13.5, 3.5, 31.5);
	paska_ao(g1, 0.4);
	paska_ao(g2, 0.4);
	paska_ao(g3, 0.4);
	sprite(g1, vec4(2.0,6.0, 1.0, 0.0), s_LEFTGUY);
	sprite(g2, vec4(2.0,6.0, 1.0, 0.0), s_MID_GUY);
	sprite(g3, vec4(2.0,6.0, 1.0, 0.0), s_RIGHTGUY);

	{
		const vec3 gsp = vec3(-3.5, 3.8, 29.0);
		paska_ao(gsp, 0.3);
		paska_ao(gsp+vec3(0.0,0.0,-3.0), 0.3);
		gsprite(gsp, vec4(12.0,16.0, 3.0, 4.0));
	}

#endif

	float waterlevel = 3.0;// + sin(rp.z * 5.0 + ft * 3.0) * 0.03;
	if (rp.y < waterlevel)
	{
		vec3 wp = rp;
		wp.y = waterlevel;


		vec3 waurinkodir = normalize(aurinko - wp);

		vec3 waternormal = vec3(0.0,1.0, 0.0);
//			waternormal.z += cos(rp.z * 5.0 + ft * 3.0) * 0.03;
//			waternormal = normalize(waternormal);
		vec3 ref = reflect(rd, waternormal);
		vec3 watercol = vec3(0.2, 0.5, 1.0) * clamp(dot(waurinkodir, waternormal), 0.0, 1.0) * 0.8;
		watercol += vec3(1.0, 1.0, 0.7) * pow(clamp(dot(waurinkodir, ref), 0.0, 1.0), 37.0);
		watercol += vec3(0.2) * clouds(wp, ref);

		g_col = mix(g_col, watercol, 0.6);
	}

	if (u_logo > 0.01)
		logo();

	return vec4(g_col, 0.0);

}
