uniform vec2 u_mouse;
uniform float u_zoom;
uniform float u_ldbegin;
uniform float u_ldmix;
uniform float u_barhide;
uniform float u_loada;
uniform float u_brightmul;

uniform float u_begin;


vec4 get_laserdisc()
{
	float ft = motionblur(2.0) - u_ldbegin;
	float ang2d = pow(abs(ft),2.7)*sign(ft);
	float zoomlevel = pow(max(0.0, 1.0+ft*0.15),5.0)/3.0;

	  mat2 mat2d = mat2(cos(ang2d), sin(ang2d), -sin(ang2d), cos(ang2d));

	 vec2 rotuv = mat2d*uv2*zoomlevel;
	vec4 c = texture2D(iChannel3, rotuv+vec2(0.5));
//	float riseup = max(atan(rotuv.x, rotuv.y) * 13.0 + length(rotuv)*3.14159*1.0, 0.0) * 0.1;

	c.a = clamp((length(rotuv) - (0.48))* 100.0, 0.0, 1.0);
	c.a = max(c.a, clamp(1.0 - (length(rotuv) - 0.05)* 100.0, 0.0, 1.0));

	return c;
}

vec2 applyspace(vec2 orig)
{
	vec2 tp = orig * 0.1;

	tp *= 20.0/(9.0+length(orig)*2.0);

	return tp;
}

float insidetile(vec2 uv)
{
	float res = -100.0;
	res = max(res, dot(abs(uv-vec2(0.5)), vec2(1.0)) - 0.8);
	res = max(res, dot(abs(uv-vec2(0.5)), vec2(0.0, 1.0)) - 0.47);
	res = max(res, dot(abs(uv-vec2(0.5)), vec2(1.0, 0.0)) - 0.47);
	return res;
}

void cursor(inout vec4 c, vec2 cp)
{
//    if (length(cp-uv2) < 0.03)
//        c = vec4(0.0,1.0,0.0,0.0);

//    vec2 p1 = cp;
//    vec2 p2 = cp+vec2(0.5);
//    vec2 p = (uv2-p1)/(p2-p1);

	vec2 p = (uv2-cp+vec2(0.0,0.3))/0.3;


	if (p.x < 0.0 || p.y < 0.0 || p.x > 1.0 || p.y > 1.0)
		return;

	vec4 tc = texture2D(iChannel1, p/4.0);

	c.rgb = mix(c.rgb, vec3(tc.r), tc.g);
}

void loadingtext(inout vec4 c)
{
	vec2 tc = uv2*0.5+vec2(0.5);
	tc *= vec2(1.4, 7.0);
	float ft = motionblur(5.0);
	tc.x += ft * 0.6 * sin( (floor(tc.y) * 1.4 + 5.0)) * 1.0;

	c -= texture2D(iChannel2, tc) * u_loada * c.a;
}

vec4 function()
{
	float ft = motionblur(2.0);
	float valoisuus = max(0.0, 0.6-length(uv2)*0.3);
	vec4 c = pow(texture2D(iChannel0, uv2*0.8+vec2(0.5,ft*0.4)) * valoisuus, vec4(2.0));


	vec2 mp = vec2(0.0);
//	mp = u_mouse;
	mp.x += cos(ft*2.133123) * 0.6;
	mp.y += sin(ft*2.5) * 0.6;
	float fm = 0.5 + sin(ft*0.9) * 0.5 * u_zoom;
	mp.x += cos(ft*5.323) * 0.2 * fm;
	mp.y += sin(ft*4.2212) * 0.2 * fm;
	float fm2 = pow(fm, 2.0);
	mp.x += cos(ft*8.623) * 0.09 * fm2;
	mp.y += sin(ft*9.3212) * 0.09 * fm2;

	vec2 uv2b = uv2;

	uv2b = (uv2b-mp) * u_zoom + mp;


	vec2 wp = applyspace(uv2b);
	vec2 mwp = applyspace(mp);



	vec2 dir = vec2(0.0);
//    dir.x += ft;
	dir += mp * 0.16 * u_zoom;
	dir.y -= ft * 0.23;
	dir.x += ft * 0.13;

	wp += dir;
	mwp += dir;



	vec2 tile = floor(wp * 5.0);
	vec2 tileuv = fract(wp * 5.0);

	vec2 mtile = floor(mwp * 5.0);
	vec2 mtileuv = fract(mwp * 5.0);

	if (insidetile(mtileuv) > 0.0)
		mtile.x = -10000.0;

//        return vec4(0.0);

	float tiledist = insidetile(tileuv);
	if (tiledist <= 0.0)
	{
		float iconnum = mod(dot(tile, vec2(1.0, 3.0)), 12.0);
//        vec2 iconpos = mod(tile, vec2(4.0, 3.0)) + vec2(0.0, 1.0);
		vec2 iconpos = vec2(mod(iconnum, 4.0), floor(iconnum / 4.0)) + vec2(0.0, 1.0);
		vec4 nc = texture2D(iChannel1, (tileuv + iconpos)/4.0);
//		if (mod(tile,vec2(2.0,2.0)) == vec2(0.0, 0.0))
//			nc = texture2D(iChannel2, tileuv);

//	    c.rgb *= mod(tile.xyx, vec3(5.0))/4.0;

		if (tile == mtile)
			nc.rgb += vec3(0.1+sin(ft*20.0)*0.9);

			nc.rgb *= pow(min(1.0, -tiledist * 5.0), 0.33);

//	    c += vec4(max(0.0, 1.0 - length(mwp-wp) * 4.0));
			c = mix(c, nc, nc.a);

		}

//    if (length(mwp-wp) < 0.01)
//    	c = vec4(1.0,0.0,0.0,0.0);

	// outputs c.a as disc alpha
	c = mix(c, get_laserdisc(), u_ldmix);

	loadingtext(c);


	float fadepos = (ft - u_begin) * 2.0;
	if (fadepos < (uv.y+uv.x))
		c = vec4(0.0);


	vec4 friendbar = texture2D(iChannel4, uv2 * vec2(0.4, 2.0) + vec2(0.5, 3.9-u_barhide*2.0));

	c = mix(c, friendbar, friendbar.a);

	cursor(c, mp);

	c *= u_brightmul;

	return c;
}