/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.windows;

import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.UpstreamSurfaceHook;
import jogamp.nativewindow.ProxySurfaceImpl;
import jogamp.nativewindow.windows.GDI;

public class GDISurface
extends ProxySurfaceImpl {
    private long windowHandle;
    private long surfaceHandle;

    public GDISurface(AbstractGraphicsConfiguration abstractGraphicsConfiguration, long l, UpstreamSurfaceHook upstreamSurfaceHook, boolean bl) {
        super(abstractGraphicsConfiguration, upstreamSurfaceHook, bl);
        this.windowHandle = l;
        this.surfaceHandle = 0L;
    }

    @Override
    protected void invalidateImpl() {
        if (0L != this.surfaceHandle) {
            throw new NativeWindowException("didn't release surface Handle: " + this);
        }
        this.windowHandle = 0L;
    }

    @Override
    public final void setSurfaceHandle(long l) {
        this.windowHandle = l;
    }

    public final void setWindowHandle(long l) {
        this.windowHandle = l;
    }

    public final long getWindowHandle() {
        return this.windowHandle;
    }

    @Override
    protected final int lockSurfaceImpl() {
        if (0L == this.windowHandle) {
            throw new NativeWindowException("null window handle: " + this);
        }
        if (0L != this.surfaceHandle) {
            throw new InternalError("surface not released");
        }
        this.surfaceHandle = GDI.GetDC(this.windowHandle);
        return 0L != this.surfaceHandle ? 3 : 1;
    }

    @Override
    protected final void unlockSurfaceImpl() {
        if (0L != this.surfaceHandle) {
            if (0 == GDI.ReleaseDC(this.windowHandle, this.surfaceHandle)) {
                throw new NativeWindowException("DC not released: " + this + ", isWindow " + GDI.IsWindow(this.windowHandle) + ", werr " + GDI.GetLastError() + ", thread: " + Thread.currentThread().getName());
            }
            this.surfaceHandle = 0L;
        }
    }

    @Override
    public final long getSurfaceHandle() {
        return this.surfaceHandle;
    }

    @Override
    public final int[] convertToWindowUnits(int[] nArray) {
        return nArray;
    }

    @Override
    public final int[] convertToPixelUnits(int[] nArray) {
        return nArray;
    }
}

