/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import javax.media.opengl.GL;
import javax.media.opengl.GL2ES2;
import javax.media.opengl.GL2ES3;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;

public class GLPixelStorageModes {
    private final int[] cachePack = new int[8];
    private final int[] cacheUnpack = new int[8];
    private boolean savedPack = false;
    private boolean savedUnpack = false;

    public GLPixelStorageModes() {
    }

    public GLPixelStorageModes(GL gL) {
        this.saveAll(gL);
    }

    public final void setPackAlignment(GL gL, int n) {
        this.savePack(gL);
        gL.glPixelStorei(3333, n);
    }

    public final void setUnpackAlignment(GL gL, int n) {
        this.saveUnpack(gL);
        gL.glPixelStorei(3317, n);
    }

    public final void setAlignment(GL gL, int n, int n2) {
        this.setPackAlignment(gL, n);
        this.setUnpackAlignment(gL, n2);
    }

    public final void setPackRowLength(GL2ES3 gL2ES3, int n) {
        this.savePack(gL2ES3);
        gL2ES3.glPixelStorei(3330, n);
    }

    public final void setUnpackRowLength(GL2ES2 gL2ES2, int n) {
        this.saveUnpack(gL2ES2);
        gL2ES2.glPixelStorei(3314, n);
    }

    public final void setRowLength(GL2ES3 gL2ES3, int n, int n2) {
        this.setPackRowLength(gL2ES3, n);
        this.setUnpackRowLength(gL2ES3, n2);
    }

    public final void saveAll(GL gL) {
        this.savePack(gL);
        this.saveUnpack(gL);
    }

    public final void resetAll(GL gL) {
        this.resetPack(gL);
        this.resetUnpack(gL);
    }

    public final void restore(GL gL) throws GLException {
        if (!this.savedPack && !this.savedUnpack) {
            throw new GLException("Neither PACK nor UNPACK pixel storage modes were saved");
        }
        if (this.savedPack) {
            this.restorePack(gL);
            this.savedPack = false;
        }
        if (this.savedUnpack) {
            this.restoreUnpack(gL);
            this.savedUnpack = false;
        }
    }

    public final void resetPack(GL gL) {
        gL.glPixelStorei(3333, 4);
        if (gL.isGL2ES3()) {
            gL.glPixelStorei(3330, 0);
            gL.glPixelStorei(3331, 0);
            gL.glPixelStorei(3332, 0);
            if (gL.isGL2GL3()) {
                gL.glPixelStorei(3328, 0);
                gL.glPixelStorei(3329, 0);
                if (gL.getContext().getGLVersionNumber().compareTo(GLContext.Version120) >= 0) {
                    gL.glPixelStorei(32876, 0);
                    gL.glPixelStorei(32875, 0);
                }
            }
        }
    }

    public final void savePack(GL gL) {
        if (this.savedPack) {
            return;
        }
        if (gL.isGL2()) {
            gL.getGL2().glPushClientAttrib(1);
        } else {
            gL.glGetIntegerv(3333, this.cachePack, 0);
            if (gL.isGL2ES3()) {
                gL.glGetIntegerv(3330, this.cachePack, 1);
                gL.glGetIntegerv(3331, this.cachePack, 2);
                gL.glGetIntegerv(3332, this.cachePack, 3);
                if (gL.isGL2GL3()) {
                    gL.glGetIntegerv(3328, this.cachePack, 4);
                    gL.glGetIntegerv(3329, this.cachePack, 5);
                    gL.glGetIntegerv(32876, this.cachePack, 6);
                    gL.glGetIntegerv(32875, this.cachePack, 7);
                }
            }
        }
        this.savedPack = true;
        this.resetPack(gL);
    }

    private final void restorePack(GL gL) {
        if (gL.isGL2()) {
            gL.getGL2().glPopClientAttrib();
        } else {
            gL.glPixelStorei(3333, this.cachePack[0]);
            if (gL.isGL2ES3()) {
                gL.glPixelStorei(3330, this.cachePack[1]);
                gL.glPixelStorei(3331, this.cachePack[2]);
                gL.glPixelStorei(3332, this.cachePack[3]);
                if (gL.isGL2GL3()) {
                    gL.glPixelStorei(3328, this.cachePack[4]);
                    gL.glPixelStorei(3329, this.cachePack[5]);
                    gL.glPixelStorei(32876, this.cachePack[6]);
                    gL.glPixelStorei(32875, this.cachePack[7]);
                }
            }
        }
    }

    public final void resetUnpack(GL gL) {
        gL.glPixelStorei(3317, 4);
        if (gL.isGL2ES3()) {
            gL.glPixelStorei(3314, 0);
            gL.glPixelStorei(3315, 0);
            gL.glPixelStorei(3316, 0);
            if (gL.isGL2GL3()) {
                if (gL.getContext().getGLVersionNumber().compareTo(GLContext.Version120) >= 0) {
                    gL.glPixelStorei(32878, 0);
                    gL.glPixelStorei(32877, 0);
                }
                gL.glPixelStorei(3312, 0);
                gL.glPixelStorei(3313, 0);
            } else {
                gL.glPixelStorei(32878, 0);
                gL.glPixelStorei(32877, 0);
            }
        }
    }

    public final void saveUnpack(GL gL) {
        if (this.savedUnpack) {
            return;
        }
        if (gL.isGL2()) {
            gL.getGL2().glPushClientAttrib(1);
        } else {
            gL.glGetIntegerv(3317, this.cacheUnpack, 0);
            if (gL.isGL2ES3()) {
                gL.glGetIntegerv(3314, this.cacheUnpack, 1);
                gL.glGetIntegerv(3315, this.cacheUnpack, 2);
                gL.glGetIntegerv(3316, this.cacheUnpack, 3);
                gL.glGetIntegerv(32878, this.cacheUnpack, 4);
                gL.glGetIntegerv(32877, this.cacheUnpack, 5);
                if (gL.isGL2GL3()) {
                    gL.glGetIntegerv(3312, this.cacheUnpack, 6);
                    gL.glGetIntegerv(3313, this.cacheUnpack, 7);
                }
            }
        }
        this.savedUnpack = true;
        this.resetUnpack(gL);
    }

    private final void restoreUnpack(GL gL) {
        if (gL.isGL2()) {
            gL.getGL2().glPopClientAttrib();
        } else {
            gL.glPixelStorei(3317, this.cacheUnpack[0]);
            if (gL.isGL2ES3()) {
                gL.glPixelStorei(3314, this.cacheUnpack[1]);
                gL.glPixelStorei(3315, this.cacheUnpack[2]);
                gL.glPixelStorei(3316, this.cacheUnpack[3]);
                gL.glPixelStorei(32878, this.cacheUnpack[4]);
                gL.glPixelStorei(32877, this.cacheUnpack[5]);
                if (gL.isGL2GL3()) {
                    gL.glPixelStorei(3312, this.cacheUnpack[6]);
                    gL.glPixelStorei(3313, this.cacheUnpack[7]);
                }
            }
        }
    }
}

