/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.opengl.util.AnimatorBase;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLException;

public class Animator
extends AnimatorBase {
    protected ThreadGroup threadGroup;
    protected boolean isAnimating;
    protected boolean pauseIssued;
    protected volatile boolean stopIssued;
    private ThreadGroup threadGroup2;
    private Runnable runnable;
    private boolean runAsFastAsPossible;
    boolean isAnimating2;
    volatile boolean pauseIssued2;
    volatile boolean stopIssued2;
    private final AnimatorBase.Condition waitForStartedCondition = new AnimatorBase.Condition(){

        @Override
        public boolean eval() {
            return !Animator.this.isStarted() || !Animator.this.drawablesEmpty && !Animator.this.isAnimating2;
        }
    };
    private final AnimatorBase.Condition waitForStoppedCondition = new AnimatorBase.Condition(){

        @Override
        public boolean eval() {
            return Animator.this.isStarted();
        }
    };
    private final AnimatorBase.Condition waitForPausedCondition = new AnimatorBase.Condition(){

        @Override
        public boolean eval() {
            return Animator.this.isStarted() && Animator.this.isAnimating2;
        }
    };
    private final AnimatorBase.Condition waitForResumeCondition = new AnimatorBase.Condition(){

        @Override
        public boolean eval() {
            return Animator.this.isStarted() && (!Animator.this.drawablesEmpty && !Animator.this.isAnimating2 || Animator.this.drawablesEmpty && !Animator.this.pauseIssued2);
        }
    };

    public Animator() {
        if (DEBUG) {
            System.err.println("Animator created");
        }
    }

    public Animator(ThreadGroup threadGroup) {
        this.setThreadGroup(threadGroup);
        if (DEBUG) {
            System.err.println("Animator created, ThreadGroup: " + this.threadGroup2);
        }
    }

    public Animator(GLAutoDrawable gLAutoDrawable) {
        this.add(gLAutoDrawable);
        if (DEBUG) {
            System.err.println("Animator created, w/ " + gLAutoDrawable);
        }
    }

    public Animator(ThreadGroup threadGroup, GLAutoDrawable gLAutoDrawable) {
        this.setThreadGroup(threadGroup);
        this.add(gLAutoDrawable);
        if (DEBUG) {
            System.err.println("Animator created, ThreadGroup: " + this.threadGroup2 + " and " + gLAutoDrawable);
        }
    }

    @Override
    protected final String getBaseName(String string) {
        return string + "Animator";
    }

    public final synchronized void setRunAsFastAsPossible(boolean bl) {
        this.runAsFastAsPossible = bl;
    }

    @Override
    public final synchronized boolean isAnimating() {
        return this.animThread != null && this.isAnimating2;
    }

    @Override
    public final synchronized boolean isPaused() {
        return this.animThread != null && this.pauseIssued2;
    }

    public final synchronized void setThreadGroup(ThreadGroup threadGroup) throws GLException {
        if (this.isStarted()) {
            throw new GLException("Animator already started.");
        }
        this.threadGroup2 = threadGroup;
    }

    @Override
    public final synchronized boolean start() {
        if (this.isStarted()) {
            return false;
        }
        if (this.runnable == null) {
            this.runnable = new MainLoop();
        }
        this.fpsCounter.resetFPSCounter();
        String string = Animator.getThreadName() + "-" + this.baseName;
        Thread thread = null == this.threadGroup2 ? new Thread(this.runnable, string) : new Thread(this.threadGroup2, this.runnable, string);
        thread.setDaemon(false);
        if (DEBUG) {
            Thread thread2 = Thread.currentThread();
            System.err.println("Animator " + thread2.getName() + "[daemon " + thread2.isDaemon() + "]: starting " + thread.getName() + "[daemon " + thread.isDaemon() + "]");
        }
        thread.start();
        return this.finishLifecycleAction(this.waitForStartedCondition, 0L);
    }

    @Override
    public final synchronized boolean stop() {
        if (!this.isStarted()) {
            return false;
        }
        this.stopIssued2 = true;
        return this.finishLifecycleAction(this.waitForStoppedCondition, 0L);
    }

    @Override
    public final synchronized boolean pause() {
        if (!this.isStarted() || this.pauseIssued2) {
            return false;
        }
        this.pauseIssued2 = true;
        return this.finishLifecycleAction(this.waitForPausedCondition, 0L);
    }

    @Override
    public final synchronized boolean resume() {
        if (!this.isStarted() || !this.pauseIssued2) {
            return false;
        }
        this.pauseIssued2 = false;
        return this.finishLifecycleAction(this.waitForResumeCondition, 0L);
    }

    class MainLoop
    implements Runnable {
        MainLoop() {
        }

        public String toString() {
            return "[started " + Animator.this.isStarted() + ", animating " + Animator.this.isAnimating() + ", paused " + Animator.this.isPaused() + ", drawable " + Animator.this.drawables.size() + ", drawablesEmpty " + Animator.this.drawablesEmpty + "]";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean bl;
            ThreadDeath threadDeath = null;
            AnimatorBase.UncaughtAnimatorException uncaughtAnimatorException = null;
            try {
                Animator animator = Animator.this;
                synchronized (animator) {
                    if (AnimatorBase.DEBUG) {
                        System.err.println("Animator start on " + AnimatorBase.getThreadName() + ": " + this.toString());
                    }
                    Animator.this.fpsCounter.resetFPSCounter();
                    Animator.this.animThread = Thread.currentThread();
                    Animator.this.isAnimating2 = false;
                }
                while (!Animator.this.stopIssued2) {
                    animator = Animator.this;
                    synchronized (animator) {
                        bl = false;
                        while (!Animator.this.stopIssued2 && (Animator.this.pauseIssued2 || Animator.this.drawablesEmpty)) {
                            if (Animator.this.drawablesEmpty) {
                                Animator.this.pauseIssued2 = true;
                            }
                            boolean bl2 = Animator.this.pauseIssued2;
                            if (AnimatorBase.DEBUG) {
                                System.err.println("Animator pause on " + Animator.this.animThread.getName() + ": " + this.toString());
                            }
                            if (Animator.this.exclusiveContext && !Animator.this.drawablesEmpty && !bl) {
                                bl = true;
                                Animator.this.setDrawablesExclCtxState(false);
                                try {
                                    Animator.this.display();
                                }
                                catch (AnimatorBase.UncaughtAnimatorException uncaughtAnimatorException2) {
                                    uncaughtAnimatorException = uncaughtAnimatorException2;
                                    Animator.this.stopIssued2 = true;
                                    break;
                                }
                            }
                            Animator.this.isAnimating2 = false;
                            Animator.this.notifyAll();
                            try {
                                Animator.this.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (!bl2) continue;
                            Animator.this.fpsCounter.resetFPSCounter();
                            if (!AnimatorBase.DEBUG) continue;
                            System.err.println("Animator resume on " + Animator.this.animThread.getName() + ": " + this.toString());
                        }
                        if (!Animator.this.stopIssued2 && !Animator.this.isAnimating2) {
                            Animator.this.isAnimating2 = true;
                            Animator.this.setDrawablesExclCtxState(Animator.this.exclusiveContext);
                            Animator.this.notifyAll();
                        }
                    }
                    if (Animator.this.pauseIssued2 || Animator.this.stopIssued2) continue;
                    try {
                        Animator.this.display();
                    }
                    catch (AnimatorBase.UncaughtAnimatorException uncaughtAnimatorException3) {
                        uncaughtAnimatorException = uncaughtAnimatorException3;
                        Animator.this.stopIssued2 = true;
                        break;
                    }
                    if (Animator.this.runAsFastAsPossible) continue;
                    Thread.yield();
                }
            }
            catch (ThreadDeath threadDeath2) {
                if (AnimatorBase.DEBUG) {
                    System.err.println("Animator caught: " + threadDeath2.getClass().getName() + ": " + threadDeath2.getMessage());
                    threadDeath2.printStackTrace();
                }
                threadDeath = threadDeath2;
            }
            if (Animator.this.exclusiveContext && !Animator.this.drawablesEmpty) {
                Animator.this.setDrawablesExclCtxState(false);
                try {
                    Animator.this.display();
                }
                catch (AnimatorBase.UncaughtAnimatorException uncaughtAnimatorException4) {
                    if (null == uncaughtAnimatorException) {
                        uncaughtAnimatorException = uncaughtAnimatorException4;
                    }
                    System.err.println("Animator.setExclusiveContextThread: caught: " + uncaughtAnimatorException4.getMessage());
                    uncaughtAnimatorException4.printStackTrace();
                }
            }
            boolean bl3 = false;
            bl = false;
            Animator animator = Animator.this;
            synchronized (animator) {
                if (AnimatorBase.DEBUG) {
                    System.err.println("Animator stop on " + Animator.this.animThread.getName() + ": " + this.toString());
                    if (null != uncaughtAnimatorException) {
                        System.err.println("Animator caught: " + uncaughtAnimatorException.getMessage());
                        uncaughtAnimatorException.printStackTrace();
                    }
                }
                Animator.this.stopIssued2 = false;
                Animator.this.pauseIssued2 = false;
                Animator.this.isAnimating2 = false;
                if (null != uncaughtAnimatorException) {
                    bl3 = true;
                    if (null != Animator.this.uncaughtExceptionHandler) {
                        Animator.this.handleUncaughtException(uncaughtAnimatorException);
                        bl = false;
                    } else {
                        bl = true;
                    }
                }
                Animator.this.animThread = null;
                Animator.this.notifyAll();
            }
            if (bl3) {
                Animator.this.flushGLRunnables();
            }
            if (bl) {
                throw uncaughtAnimatorException;
            }
            if (null != threadDeath) {
                throw threadDeath;
            }
        }
    }
}

