/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.nativewindow.DelegatedUpstreamSurfaceHookWithSurfaceSize;
import com.jogamp.nativewindow.MutableGraphicsConfiguration;
import com.jogamp.nativewindow.UpstreamSurfaceHookMutableSize;
import com.jogamp.opengl.GLAutoDrawableDelegate;
import com.jogamp.opengl.GLRendererQuirks;
import java.nio.Buffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.MutableSurface;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.OffscreenLayerSurface;
import javax.media.nativewindow.ProxySurface;
import javax.media.nativewindow.UpstreamSurfaceHook;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLFBODrawable;
import javax.media.opengl.GLOffscreenAutoDrawable;
import javax.media.opengl.GLProfile;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLDynamicLookupHelper;
import jogamp.opengl.GLFBODrawableImpl;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import jogamp.opengl.GLOffscreenAutoDrawableImpl;
import jogamp.opengl.SharedResourceRunner;

public abstract class GLDrawableFactoryImpl
extends GLDrawableFactory {
    protected static final boolean DEBUG = GLDrawableFactory.DEBUG;
    private final Map<DeviceScreenID, Buffer> screen2OrigGammaRamp = new HashMap<DeviceScreenID, Buffer>();

    protected GLDrawableFactoryImpl() {
    }

    protected final SharedResourceRunner.Resource getOrCreateSharedResource(AbstractGraphicsDevice abstractGraphicsDevice) {
        block3: {
            try {
                abstractGraphicsDevice = this.validateDevice(abstractGraphicsDevice);
                if (null != abstractGraphicsDevice) {
                    return this.getOrCreateSharedResourceImpl(abstractGraphicsDevice);
                }
            }
            catch (GLException gLException) {
                if (!DEBUG) break block3;
                System.err.println("Caught exception on thread " + GLDrawableFactoryImpl.getThreadName());
                gLException.printStackTrace();
            }
        }
        return null;
    }

    protected abstract SharedResourceRunner.Resource getOrCreateSharedResourceImpl(AbstractGraphicsDevice var1);

    public final GLContext getOrCreateSharedContext(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResourceRunner.Resource resource = this.getOrCreateSharedResource(abstractGraphicsDevice);
        if (null != resource) {
            return resource.getContext();
        }
        return null;
    }

    @Override
    protected final boolean createSharedResourceImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResourceRunner.Resource resource = this.getOrCreateSharedResource(abstractGraphicsDevice);
        if (null != resource) {
            return resource.isValid();
        }
        return false;
    }

    @Override
    public final GLRendererQuirks getRendererQuirks(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResourceRunner.Resource resource = this.getOrCreateSharedResource(abstractGraphicsDevice);
        if (null != resource) {
            return resource.getRendererQuirks();
        }
        return null;
    }

    protected final AbstractGraphicsDevice getOrCreateSharedDevice(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResourceRunner.Resource resource = this.getOrCreateSharedResource(abstractGraphicsDevice);
        if (null != resource) {
            return resource.getDevice();
        }
        return null;
    }

    public abstract GLDynamicLookupHelper getGLDynamicLookupHelper(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final GLDrawable createGLDrawable(NativeSurface nativeSurface) {
        if (nativeSurface == null) {
            throw new IllegalArgumentException("Null target");
        }
        MutableGraphicsConfiguration mutableGraphicsConfiguration = (MutableGraphicsConfiguration)nativeSurface.getGraphicsConfiguration();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)mutableGraphicsConfiguration.getChosenCapabilities();
        AbstractGraphicsDevice abstractGraphicsDevice = mutableGraphicsConfiguration.getScreen().getDevice();
        boolean bl = GLContext.isFBOAvailable(abstractGraphicsDevice, gLCapabilitiesImmutable.getGLProfile());
        GLDrawable gLDrawable = null;
        abstractGraphicsDevice.lock();
        try {
            OffscreenLayerSurface offscreenLayerSurface = NativeWindowFactory.getOffscreenLayerSurface(nativeSurface, true);
            if (null != offscreenLayerSurface) {
                GLCapabilitiesImmutable gLCapabilitiesImmutable2 = GLGraphicsConfigurationUtil.fixOffscreenGLCapabilities(gLCapabilitiesImmutable, this, abstractGraphicsDevice);
                if (!gLCapabilitiesImmutable2.isFBO() && !gLCapabilitiesImmutable2.isPBuffer()) {
                    throw new GLException("Neither FBO nor Pbuffer is available for " + gLCapabilitiesImmutable2 + ", " + nativeSurface);
                }
                mutableGraphicsConfiguration.setChosenCapabilities(gLCapabilitiesImmutable2);
                offscreenLayerSurface.setChosenCapabilities(gLCapabilitiesImmutable2);
                if (DEBUG) {
                    System.err.println("GLDrawableFactoryImpl.createGLDrawable -> OnscreenDrawable -> Offscreen-Layer");
                    System.err.println("chosenCaps:    " + gLCapabilitiesImmutable);
                    System.err.println("chosenCapsMod: " + gLCapabilitiesImmutable2);
                    System.err.println("OffscreenLayerSurface: **** " + offscreenLayerSurface);
                    System.err.println("Target: **** " + nativeSurface);
                    Thread.dumpStack();
                }
                if (!(nativeSurface instanceof MutableSurface)) {
                    throw new IllegalArgumentException("Passed NativeSurface must implement SurfaceChangeable for offscreen layered surface: " + nativeSurface);
                }
                gLDrawable = gLCapabilitiesImmutable2.isFBO() ? this.createFBODrawableImpl(nativeSurface, gLCapabilitiesImmutable2, 0) : this.createOffscreenDrawableImpl(nativeSurface);
            } else if (gLCapabilitiesImmutable.isOnscreen()) {
                GLCapabilitiesImmutable gLCapabilitiesImmutable3 = GLGraphicsConfigurationUtil.fixOnscreenGLCapabilities(gLCapabilitiesImmutable);
                mutableGraphicsConfiguration.setChosenCapabilities(gLCapabilitiesImmutable3);
                if (DEBUG) {
                    System.err.println("GLDrawableFactoryImpl.createGLDrawable -> OnscreenDrawable: " + nativeSurface);
                }
                gLDrawable = this.createOnscreenDrawableImpl(nativeSurface);
            } else {
                if (DEBUG) {
                    System.err.println("GLDrawableFactoryImpl.createGLDrawable -> OffScreenDrawable, FBO chosen / avail, PBuffer: " + gLCapabilitiesImmutable.isFBO() + " / " + bl + ", " + gLCapabilitiesImmutable.isPBuffer() + ": " + nativeSurface);
                }
                if (!(nativeSurface instanceof MutableSurface)) {
                    throw new IllegalArgumentException("Passed NativeSurface must implement MutableSurface for offscreen: " + nativeSurface);
                }
                if (gLCapabilitiesImmutable.isFBO() && bl) {
                    ProxySurface proxySurface = this.createDummySurfaceImpl(abstractGraphicsDevice, false, new GLCapabilities(gLCapabilitiesImmutable.getGLProfile()), (GLCapabilitiesImmutable)mutableGraphicsConfiguration.getRequestedCapabilities(), null, 64, 64);
                    proxySurface.setUpstreamSurfaceHook(new DelegatedUpstreamSurfaceHookWithSurfaceSize(proxySurface.getUpstreamSurfaceHook(), nativeSurface));
                    gLDrawable = this.createFBODrawableImpl(proxySurface, gLCapabilitiesImmutable, 0);
                } else {
                    gLDrawable = this.createOffscreenDrawableImpl(nativeSurface);
                }
            }
        }
        finally {
            abstractGraphicsDevice.unlock();
        }
        if (DEBUG) {
            System.err.println("GLDrawableFactoryImpl.createGLDrawable: " + gLDrawable);
        }
        return gLDrawable;
    }

    protected abstract GLDrawableImpl createOnscreenDrawableImpl(NativeSurface var1);

    @Override
    public abstract boolean canCreateGLPbuffer(AbstractGraphicsDevice var1, GLProfile var2);

    @Override
    public final boolean canCreateFBO(AbstractGraphicsDevice abstractGraphicsDevice, GLProfile gLProfile) {
        AbstractGraphicsDevice abstractGraphicsDevice2 = this.getOrCreateSharedDevice(abstractGraphicsDevice);
        if (null == abstractGraphicsDevice2) {
            throw new GLException("No shared device for requested: " + abstractGraphicsDevice);
        }
        return GLContext.isFBOAvailable(abstractGraphicsDevice2, gLProfile);
    }

    @Override
    public final GLOffscreenAutoDrawable createOffscreenAutoDrawable(AbstractGraphicsDevice abstractGraphicsDevice, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser, int n, int n2) {
        GLDrawable gLDrawable = this.createOffscreenDrawable(abstractGraphicsDevice, gLCapabilitiesImmutable, gLCapabilitiesChooser, n, n2);
        try {
            gLDrawable.setRealized(true);
        }
        catch (GLException gLException) {
            try {
                gLDrawable.setRealized(false);
            }
            catch (GLException gLException2) {
                // empty catch block
            }
            throw gLException;
        }
        if (gLDrawable instanceof GLFBODrawableImpl) {
            return new GLOffscreenAutoDrawableImpl.FBOImpl((GLFBODrawableImpl)gLDrawable, null, null, null);
        }
        return new GLOffscreenAutoDrawableImpl(gLDrawable, null, null, null);
    }

    @Override
    public final GLAutoDrawable createDummyAutoDrawable(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser) {
        GLDrawable gLDrawable = this.createDummyDrawable(abstractGraphicsDevice, bl, gLCapabilitiesImmutable, gLCapabilitiesChooser);
        try {
            gLDrawable.setRealized(true);
        }
        catch (GLException gLException) {
            try {
                gLDrawable.setRealized(false);
            }
            catch (GLException gLException2) {
                // empty catch block
            }
            throw gLException;
        }
        GLAutoDrawableDelegate gLAutoDrawableDelegate = new GLAutoDrawableDelegate(gLDrawable, null, null, true, null){};
        return gLAutoDrawableDelegate;
    }

    @Override
    public final GLDrawable createOffscreenDrawable(AbstractGraphicsDevice abstractGraphicsDevice, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser, int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new GLException("initial size must be positive (were (" + n + " x " + n2 + "))");
        }
        AbstractGraphicsDevice abstractGraphicsDevice2 = this.getOrCreateSharedDevice(abstractGraphicsDevice);
        if (null == abstractGraphicsDevice2) {
            throw new GLException("No shared device for requested: " + abstractGraphicsDevice);
        }
        GLCapabilitiesImmutable gLCapabilitiesImmutable2 = GLGraphicsConfigurationUtil.fixOffscreenGLCapabilities(gLCapabilitiesImmutable, this, abstractGraphicsDevice2);
        if (gLCapabilitiesImmutable2.isFBO()) {
            ProxySurface proxySurface = this.createDummySurfaceImpl(abstractGraphicsDevice2, true, new GLCapabilities(gLCapabilitiesImmutable2.getGLProfile()), gLCapabilitiesImmutable, null, n, n2);
            GLDrawableImpl gLDrawableImpl = this.createOnscreenDrawableImpl(proxySurface);
            return new GLFBODrawableImpl.ResizeableImpl(this, gLDrawableImpl, proxySurface, gLCapabilitiesImmutable2, 0);
        }
        return this.createOffscreenDrawableImpl(this.createMutableSurfaceImpl(abstractGraphicsDevice2, true, gLCapabilitiesImmutable2, gLCapabilitiesImmutable, gLCapabilitiesChooser, new UpstreamSurfaceHookMutableSize(n, n2)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final GLDrawable createDummyDrawable(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser) {
        AbstractGraphicsDevice abstractGraphicsDevice2;
        AbstractGraphicsDevice abstractGraphicsDevice3 = abstractGraphicsDevice2 = bl ? this.getOrCreateSharedDevice(abstractGraphicsDevice) : abstractGraphicsDevice;
        if (null == abstractGraphicsDevice2) {
            throw new GLException("No shared device for requested: " + abstractGraphicsDevice + ", createNewDevice " + bl);
        }
        if (!bl) {
            abstractGraphicsDevice2.lock();
        }
        try {
            ProxySurface proxySurface = this.createDummySurfaceImpl(abstractGraphicsDevice2, bl, gLCapabilitiesImmutable, gLCapabilitiesImmutable, gLCapabilitiesChooser, 64, 64);
            GLDrawableImpl gLDrawableImpl = this.createOnscreenDrawableImpl(proxySurface);
            return gLDrawableImpl;
        }
        finally {
            if (!bl) {
                abstractGraphicsDevice2.unlock();
            }
        }
    }

    protected final GLFBODrawable createFBODrawableImpl(NativeSurface nativeSurface, GLCapabilitiesImmutable gLCapabilitiesImmutable, int n) {
        GLDrawableImpl gLDrawableImpl = this.createOnscreenDrawableImpl(nativeSurface);
        return new GLFBODrawableImpl(this, gLDrawableImpl, nativeSurface, gLCapabilitiesImmutable, n);
    }

    protected abstract GLDrawableImpl createOffscreenDrawableImpl(NativeSurface var1);

    protected abstract ProxySurface createMutableSurfaceImpl(AbstractGraphicsDevice var1, boolean var2, GLCapabilitiesImmutable var3, GLCapabilitiesImmutable var4, GLCapabilitiesChooser var5, UpstreamSurfaceHook var6);

    public final ProxySurface createDummySurface(AbstractGraphicsDevice abstractGraphicsDevice, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser, int n, int n2) {
        AbstractGraphicsDevice abstractGraphicsDevice2 = this.getOrCreateSharedDevice(abstractGraphicsDevice);
        if (null == abstractGraphicsDevice2) {
            throw new GLException("No shared device for requested: " + abstractGraphicsDevice);
        }
        return this.createDummySurfaceImpl(abstractGraphicsDevice2, true, gLCapabilitiesImmutable, gLCapabilitiesImmutable, gLCapabilitiesChooser, n, n2);
    }

    public abstract ProxySurface createDummySurfaceImpl(AbstractGraphicsDevice var1, boolean var2, GLCapabilitiesImmutable var3, GLCapabilitiesImmutable var4, GLCapabilitiesChooser var5, int var6, int var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProxySurface createProxySurface(AbstractGraphicsDevice abstractGraphicsDevice, int n, long l, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser, UpstreamSurfaceHook upstreamSurfaceHook) {
        AbstractGraphicsDevice abstractGraphicsDevice2 = this.getOrCreateSharedDevice(abstractGraphicsDevice);
        if (null == abstractGraphicsDevice2) {
            throw new GLException("No shared device for requested: " + abstractGraphicsDevice);
        }
        if (0L == l) {
            throw new IllegalArgumentException("Null windowHandle");
        }
        abstractGraphicsDevice2.lock();
        try {
            ProxySurface proxySurface = this.createProxySurfaceImpl(abstractGraphicsDevice2, n, l, gLCapabilitiesImmutable, gLCapabilitiesChooser, upstreamSurfaceHook);
            return proxySurface;
        }
        finally {
            abstractGraphicsDevice2.unlock();
        }
    }

    protected abstract ProxySurface createProxySurfaceImpl(AbstractGraphicsDevice var1, int var2, long var3, GLCapabilitiesImmutable var5, GLCapabilitiesChooser var6, UpstreamSurfaceHook var7);

    protected abstract GLContext createExternalGLContextImpl();

    @Override
    public GLContext createExternalGLContext() {
        return this.createExternalGLContextImpl();
    }

    protected abstract GLDrawable createExternalGLDrawableImpl();

    @Override
    public GLDrawable createExternalGLDrawable() {
        return this.createExternalGLDrawableImpl();
    }

    public static GLDrawableFactoryImpl getFactoryImpl(GLProfile gLProfile) {
        return (GLDrawableFactoryImpl)GLDrawableFactoryImpl.getFactory(gLProfile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized boolean setDisplayGamma(NativeSurface nativeSurface, float f, float f2, float f3) throws IllegalArgumentException {
        if (f2 < -1.0f || f2 > 1.0f) {
            throw new IllegalArgumentException("Brightness must be between -1.0 and 1.0");
        }
        if (f3 < 0.0f) {
            throw new IllegalArgumentException("Contrast must be greater than 0.0");
        }
        if (1 >= nativeSurface.lockSurface()) {
            return false;
        }
        try {
            int n = this.getGammaRampLength(nativeSurface);
            if (n == 0) {
                boolean bl = false;
                return bl;
            }
            float[] fArray = new float[n];
            for (int i = 0; i < n; ++i) {
                float f4 = (float)i / (float)(n - 1);
                float f5 = (float)Math.pow(f4, f);
                f5 += f2;
                if ((f5 = (f5 - 0.5f) * f3 + 0.5f) > 1.0f) {
                    f5 = 1.0f;
                } else if (f5 < 0.0f) {
                    f5 = 0.0f;
                }
                fArray[i] = f5;
            }
            AbstractGraphicsScreen abstractGraphicsScreen = nativeSurface.getGraphicsConfiguration().getScreen();
            DeviceScreenID deviceScreenID = new DeviceScreenID(abstractGraphicsScreen.getDevice().getConnection(), abstractGraphicsScreen.getIndex());
            if (null == this.screen2OrigGammaRamp.get(deviceScreenID)) {
                this.screen2OrigGammaRamp.put(deviceScreenID, this.getGammaRamp(nativeSurface));
                if (DEBUG) {
                    System.err.println("DisplayGamma: Stored: " + deviceScreenID);
                    this.dumpGammaStore();
                }
            }
            boolean bl = this.setGammaRamp(nativeSurface, fArray);
            return bl;
        }
        finally {
            nativeSurface.unlockSurface();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void resetDisplayGamma(NativeSurface nativeSurface) {
        if (1 >= nativeSurface.lockSurface()) {
            return;
        }
        try {
            AbstractGraphicsScreen abstractGraphicsScreen = nativeSurface.getGraphicsConfiguration().getScreen();
            DeviceScreenID deviceScreenID = new DeviceScreenID(abstractGraphicsScreen.getDevice().getConnection(), abstractGraphicsScreen.getIndex());
            Buffer buffer = this.screen2OrigGammaRamp.remove(deviceScreenID);
            if (null != buffer) {
                this.resetGammaRamp(nativeSurface, buffer);
            }
        }
        finally {
            nativeSurface.unlockSurface();
        }
    }

    @Override
    public final synchronized void resetAllDisplayGamma() {
        this.resetAllDisplayGammaNoSync();
    }

    @Override
    protected final void resetAllDisplayGammaNoSync() {
        if (DEBUG) {
            System.err.println("DisplayGamma: Reset");
            this.dumpGammaStore();
        }
        Set<DeviceScreenID> set = this.screen2OrigGammaRamp.keySet();
        for (DeviceScreenID deviceScreenID : set) {
            Buffer buffer = this.screen2OrigGammaRamp.remove(deviceScreenID);
            if (null == buffer) continue;
            this.resetGammaRamp(deviceScreenID, buffer);
        }
    }

    private void dumpGammaStore() {
        Set<DeviceScreenID> set = this.screen2OrigGammaRamp.keySet();
        int n = 0;
        for (DeviceScreenID deviceScreenID : set) {
            Buffer buffer = this.screen2OrigGammaRamp.get(deviceScreenID);
            System.err.printf("%4d/%4d: %s -> %s%n", n, set.size(), deviceScreenID, buffer);
            ++n;
        }
    }

    protected int getGammaRampLength(NativeSurface nativeSurface) {
        return 0;
    }

    protected boolean setGammaRamp(NativeSurface nativeSurface, float[] fArray) {
        return false;
    }

    protected Buffer getGammaRamp(NativeSurface nativeSurface) {
        return null;
    }

    protected void resetGammaRamp(NativeSurface nativeSurface, Buffer buffer) {
    }

    protected void resetGammaRamp(DeviceScreenID deviceScreenID, Buffer buffer) {
    }

    public final class DeviceScreenID {
        public final String deviceConnection;
        public final int screenIdx;

        DeviceScreenID(String string, int n) {
            this.deviceConnection = string;
            this.screenIdx = n;
        }

        public int hashCode() {
            int n = 31 + this.deviceConnection.hashCode();
            n = (n << 5) - n + this.screenIdx;
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof DeviceScreenID) {
                DeviceScreenID deviceScreenID = (DeviceScreenID)object;
                return this.deviceConnection.equals(deviceScreenID.deviceConnection) && this.screenIdx == deviceScreenID.screenIdx;
            }
            return false;
        }

        public String toString() {
            return "DeviceScreenID[devCon " + this.deviceConnection + ", screenIdx " + this.screenIdx + ", hash 0x" + Integer.toHexString(this.hashCode()) + "]";
        }
    }
}

