/*
 * Decompiled with CFR 0.152.
 */
package processing.data;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import processing.core.PApplet;
import processing.data.Sort;

public class FloatDict {
    protected int count;
    protected String[] keys;
    protected float[] values;
    private HashMap<String, Integer> indices = new HashMap();

    public FloatDict() {
        this.count = 0;
        this.keys = new String[10];
        this.values = new float[10];
    }

    public FloatDict(int length) {
        this.count = 0;
        this.keys = new String[length];
        this.values = new float[length];
    }

    public FloatDict(BufferedReader reader) {
        String[] lines = PApplet.loadStrings(reader);
        this.keys = new String[lines.length];
        this.values = new float[lines.length];
        int i = 0;
        while (i < lines.length) {
            String[] pieces = PApplet.split(lines[i], '\t');
            if (pieces.length == 2) {
                this.keys[this.count] = pieces[0];
                this.values[this.count] = PApplet.parseFloat(pieces[1]);
                this.indices.put(pieces[0], this.count);
                ++this.count;
            }
            ++i;
        }
    }

    public FloatDict(String[] keys, float[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("key and value arrays must be the same length");
        }
        this.keys = keys;
        this.values = values;
        this.count = keys.length;
        int i = 0;
        while (i < this.count) {
            this.indices.put(keys[i], i);
            ++i;
        }
    }

    public int size() {
        return this.count;
    }

    public void clear() {
        this.count = 0;
        this.indices = new HashMap();
    }

    public String key(int index) {
        return this.keys[index];
    }

    protected void crop() {
        if (this.count != this.keys.length) {
            this.keys = PApplet.subset(this.keys, 0, this.count);
            this.values = PApplet.subset(this.values, 0, this.count);
        }
    }

    public Iterable<String> keys() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    int index = -1;

                    @Override
                    public void remove() {
                        FloatDict.this.removeIndex(this.index);
                    }

                    @Override
                    public String next() {
                        return FloatDict.this.key(++this.index);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index + 1 < FloatDict.this.size();
                    }
                };
            }
        };
    }

    public String[] keyArray() {
        return this.keyArray(null);
    }

    public String[] keyArray(String[] outgoing) {
        if (outgoing == null || outgoing.length != this.count) {
            outgoing = new String[this.count];
        }
        System.arraycopy(this.keys, 0, outgoing, 0, this.count);
        return outgoing;
    }

    public float value(int index) {
        return this.values[index];
    }

    public Iterable<Float> values() {
        return new Iterable<Float>(){

            @Override
            public Iterator<Float> iterator() {
                return new Iterator<Float>(){
                    int index = -1;

                    @Override
                    public void remove() {
                        FloatDict.this.removeIndex(this.index);
                    }

                    @Override
                    public Float next() {
                        return Float.valueOf(FloatDict.this.value(++this.index));
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index + 1 < FloatDict.this.size();
                    }
                };
            }
        };
    }

    public float[] valueArray() {
        return this.valueArray(null);
    }

    public float[] valueArray(float[] array) {
        if (array == null || array.length != this.size()) {
            array = new float[this.count];
        }
        System.arraycopy(this.values, 0, array, 0, this.count);
        return array;
    }

    public float get(String key) {
        int index = this.index(key);
        if (index == -1) {
            throw new IllegalArgumentException("No key named '" + key + "'");
        }
        return this.values[index];
    }

    public float get(String key, float alternate) {
        int index = this.index(key);
        if (index == -1) {
            return alternate;
        }
        return this.values[index];
    }

    public void set(String key, float amount) {
        int index = this.index(key);
        if (index == -1) {
            this.create(key, amount);
        } else {
            this.values[index] = amount;
        }
    }

    public boolean hasKey(String key) {
        return this.index(key) != -1;
    }

    public void add(String key, float amount) {
        int index = this.index(key);
        if (index == -1) {
            this.create(key, amount);
        } else {
            int n = index;
            this.values[n] = this.values[n] + amount;
        }
    }

    public void sub(String key, float amount) {
        this.add(key, -amount);
    }

    public void mult(String key, float amount) {
        int index = this.index(key);
        if (index != -1) {
            int n = index;
            this.values[n] = this.values[n] * amount;
        }
    }

    public void div(String key, float amount) {
        int index = this.index(key);
        if (index != -1) {
            int n = index;
            this.values[n] = this.values[n] / amount;
        }
    }

    private void checkMinMax(String functionName) {
        if (this.count == 0) {
            String msg = String.format("Cannot use %s() on an empty %s.", functionName, this.getClass().getSimpleName());
            throw new RuntimeException(msg);
        }
    }

    public int minIndex() {
        this.checkMinMax("minIndex");
        float m = Float.NaN;
        int mi = -1;
        int i = 0;
        while (i < this.count) {
            if (this.values[i] == this.values[i]) {
                m = this.values[i];
                mi = i;
                int j = i + 1;
                while (j < this.count) {
                    float d = this.values[j];
                    if (!Float.isNaN(d) && d < m) {
                        m = this.values[j];
                        mi = j;
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        return mi;
    }

    public String minKey() {
        this.checkMinMax("minKey");
        int index = this.minIndex();
        if (index == -1) {
            return null;
        }
        return this.keys[index];
    }

    public float minValue() {
        this.checkMinMax("minValue");
        int index = this.minIndex();
        if (index == -1) {
            return Float.NaN;
        }
        return this.values[index];
    }

    public int maxIndex() {
        this.checkMinMax("maxIndex");
        float m = Float.NaN;
        int mi = -1;
        int i = 0;
        while (i < this.count) {
            if (this.values[i] == this.values[i]) {
                m = this.values[i];
                mi = i;
                int j = i + 1;
                while (j < this.count) {
                    float d = this.values[j];
                    if (!Float.isNaN(d) && d > m) {
                        m = this.values[j];
                        mi = j;
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        return mi;
    }

    public String maxKey() {
        this.checkMinMax("maxKey");
        int index = this.maxIndex();
        if (index == -1) {
            return null;
        }
        return this.keys[index];
    }

    public float maxValue() {
        this.checkMinMax("maxValue");
        int index = this.maxIndex();
        if (index == -1) {
            return Float.NaN;
        }
        return this.values[index];
    }

    public int index(String what) {
        Integer found = this.indices.get(what);
        return found == null ? -1 : found;
    }

    protected void create(String what, float much) {
        if (this.count == this.keys.length) {
            this.keys = PApplet.expand(this.keys);
            this.values = PApplet.expand(this.values);
        }
        this.indices.put(what, this.count);
        this.keys[this.count] = what;
        this.values[this.count] = much;
        ++this.count;
    }

    public int remove(String key) {
        int index = this.index(key);
        if (index != -1) {
            this.removeIndex(index);
        }
        return index;
    }

    public String removeIndex(int index) {
        if (index < 0 || index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        String key = this.keys[index];
        this.indices.remove(this.keys[index]);
        int i = index;
        while (i < this.count - 1) {
            this.keys[i] = this.keys[i + 1];
            this.values[i] = this.values[i + 1];
            this.indices.put(this.keys[i], i);
            ++i;
        }
        --this.count;
        this.keys[this.count] = null;
        this.values[this.count] = 0.0f;
        return key;
    }

    public void swap(int a, int b) {
        String tkey = this.keys[a];
        float tvalue = this.values[a];
        this.keys[a] = this.keys[b];
        this.values[a] = this.values[b];
        this.keys[b] = tkey;
        this.values[b] = tvalue;
        this.indices.put(this.keys[a], a);
        this.indices.put(this.keys[b], b);
    }

    public void sortKeys() {
        this.sortImpl(true, false);
    }

    public void sortKeysReverse() {
        this.sortImpl(true, true);
    }

    public void sortValues() {
        this.sortImpl(false, false);
    }

    public void sortValuesReverse() {
        this.sortImpl(false, true);
    }

    protected void sortImpl(final boolean useKeys, final boolean reverse) {
        Sort s = new Sort(){

            @Override
            public int size() {
                if (useKeys) {
                    return FloatDict.this.count;
                }
                if (FloatDict.this.count == 0) {
                    return 0;
                }
                int right = FloatDict.this.count - 1;
                while (FloatDict.this.values[right] != FloatDict.this.values[right]) {
                    if (--right != -1) continue;
                    return 0;
                }
                int i = right;
                while (i >= 0) {
                    if (Float.isNaN(FloatDict.this.values[i])) {
                        this.swap(i, right);
                        --right;
                    }
                    --i;
                }
                return right + 1;
            }

            @Override
            public float compare(int a, int b) {
                float diff = 0.0f;
                if (useKeys) {
                    diff = FloatDict.this.keys[a].compareToIgnoreCase(FloatDict.this.keys[b]);
                    if (diff == 0.0f) {
                        return FloatDict.this.values[a] - FloatDict.this.values[b];
                    }
                } else {
                    diff = FloatDict.this.values[a] - FloatDict.this.values[b];
                    if (diff == 0.0f) {
                        diff = FloatDict.this.keys[a].compareToIgnoreCase(FloatDict.this.keys[b]);
                    }
                }
                return reverse ? -diff : diff;
            }

            @Override
            public void swap(int a, int b) {
                FloatDict.this.swap(a, b);
            }
        };
        s.run();
    }

    public FloatDict getPercent() {
        double sum = 0.0;
        float[] fArray = this.valueArray();
        int n = fArray.length;
        int n2 = 0;
        while (n2 < n) {
            float value = fArray[n2];
            sum += (double)value;
            ++n2;
        }
        FloatDict outgoing = new FloatDict();
        int i = 0;
        while (i < this.size()) {
            double percent = (double)this.value(i) / sum;
            outgoing.set(this.key(i), (float)percent);
            ++i;
        }
        return outgoing;
    }

    public FloatDict copy() {
        FloatDict outgoing = new FloatDict(this.count);
        System.arraycopy(this.keys, 0, outgoing.keys, 0, this.count);
        System.arraycopy(this.values, 0, outgoing.values, 0, this.count);
        int i = 0;
        while (i < this.count) {
            outgoing.indices.put(this.keys[i], i);
            ++i;
        }
        outgoing.count = this.count;
        return outgoing;
    }

    public void print() {
        int i = 0;
        while (i < this.size()) {
            System.out.println(String.valueOf(this.keys[i]) + " = " + this.values[i]);
            ++i;
        }
    }

    public void write(PrintWriter writer) {
        int i = 0;
        while (i < this.count) {
            writer.println(String.valueOf(this.keys[i]) + "\t" + this.values[i]);
            ++i;
        }
        writer.flush();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(this.getClass().getSimpleName()) + " size=" + this.size() + " { ");
        int i = 0;
        while (i < this.size()) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append("\"" + this.keys[i] + "\": " + this.values[i]);
            ++i;
        }
        sb.append(" }");
        return sb.toString();
    }
}

