import QtQuick 2.3
import QtQuick.Window 2.2

import SystemTime 1.0

import AdaptDemoSystem 1.0

RocketDemo {
    id: root
    visible: true
    width: windowWidth
    height: windowHeight
    focus: true

    Rocket {
        id: rocket
    }


    property real time: 0.0

    Component.onCompleted: {
        time = 10000.0
    }
    Behavior on time {
        NumberAnimation { duration: 10000*1000 }
    }



    Item {
        id: loaderImage
        anchors.fill: parent
        Rectangle {
            anchors.fill: parent
            color: "black"
        }
        Image {
            fillMode: Image.PreserveAspectFit
            anchors.fill:parent
            source: "../images/loader.png"
        }
//        Rectangle {
//            anchors.centerIn: parent
//            opacity: 1.0
//            radius: 5
//            width: 50
//            height: 10
//            color: "white"
//            rotation: time*20.0
//        }

    }

            Rectangle {
                opacity: 0.0
                radius: 5
                width: 10
                height: 10
                color: "black"
                rotation: time
            }


    Timer {
        interval: 20
        repeat: false
        running: true
        onTriggered: {
            //demoLoader.sourceComponent = demo
            demoLoader.source = "Skenes.qml"
        }
    }

    Timer {
        interval: 200
        repeat: true
        running: true
        onTriggered: {
            if (rocket.time > 220.0) {
                rocket.exitDemo();
            }
        }
    }

    Loader {
        id: demoLoader
        anchors.fill: parent
        asynchronous: true
        onStatusChanged: {
            if (demoLoader.status === Loader.Ready) {
                console.log("LOADER is ready")
                loaderImage.visible = false
                rocket.markDemoLoaded();
            }
        }
    }

    Keys.onEscapePressed: {
        console.log("esc esc")
        rocket.exitDemo();
    }

    Keys.onPressed: {
        // console.log("event.key:"+event.key)
        if (event.key === 16777268 || event.key === 82) { // F5 or R
            //console.log("jorma");
           // demoLoader.sourceComponent = undefined;
            demoLoader.source = "";
            rocket.reload();
            demoLoader.source = "Skenes.qml"
         //   demoLoader.sourceComponent = demo
        }
        if (event.key === 83) { // S
             // demoLoader.sourceComponent = demo
            // demoLoader.source = "Skenes.qml"
        }
//        if (event.key === 84) { // T
//             // demoLoader.sourceComponent = demo
//            // demoLoader.source = "Skenes.qml"
//            demoLoader.item.bDebugTexts = false;
//            console.log("pressed")
//        }
    }


    Item {
        anchors.fill: parent

        //        focus: true

        //        Keys.onEscapePressed: {
        //            console.log("esc esc")
        //            rocket.exitDemo();
        //        }

        //        MouseArea {
        //            id: mouseArea
        //            anchors.fill: parent
        ////            onClicked: {
        ////                Qt.quit();
        ////            }
        //        }

    }

}
