import QtQuick 2.3

import "../" // to import RocketScene

import AdaptDemoSystem 1.0



RocketScene {

    sceneName: "SkeneStart"

    Camera {
        property string name: "camera"
        x: sync(name + ".x")
        y: sync(name + ".y")
        z: sync(name + ".z")
        lookAtX: sync(name + ".lookAtX")
        lookAtY: sync(name + ".lookAtY")
        lookAtZ: sync(name + ".lookAtZ")
        upX: 0.0
        upY: 1.0
        upZ: 0.0
    }

    Shader {
        file: sceneDir+"sm"
    }
    SetTexture {
        file: "bg_3s.png"
    }
    SetTexture {
        file: "kivitex1s.png"
        textureUnit: 1
    }
    DrawMesh {
        property string name: "mesh1"
        file: "mesh/ps.x"
        Pos { x: 0.0; y: sync("mesh1.y"); z: 0 }
        Rot { d: sync("mesh1.rot"); ax: 0.0; ay: 1.0; az: 0.0;}
        Sca { s: sync("mesh1.scale")}
        ShaderParam {
            paramName: "g_alpha"
            paramValue: sync("mesh1.alpha")
        }
    }

    DrawOverlayMul {
        file: "logopart1.png"
        posX: sync("logo1X")
        posY: sync("logo1Y")
        overlayAlpha: sync("logoAlpha")
    }


    DrawOverlayMul {
        file: "logopart2.png"
        posX: sync("logo2X")
        posY: sync("logo2Y")
        overlayAlpha: sync("logoAlpha")

    }

}
