import QtQuick 2.3

import "../" // to import RocketScene

import AdaptDemoSystem 1.0



RocketScene {
    sceneName: "SkeneSlayer"

    anchors.fill: parent


//    Blit {
//        textureRT: "adaptBG"
//    }


    Camera {
        property string name: "camera"
        x: sync(name + ".x")
        y: sync(name + ".y")
        z: sync(name + ".z")
        lookAtX: sync(name + ".lookAtX")
        lookAtY: sync(name + ".lookAtY")
        lookAtZ: sync(name + ".lookAtZ")
        upX: 0.0
        upY: 1.0
        upZ: 0.0
    }

    Shader {
        file: sceneDir+"sm"
    }
    Texture {
        textureUnit: 0
        textureItem: kuva
            Image {
                visible: false
                // width: windowWidth
                //height: windowHeight
                // fillMode: Image.PreserveAspectFit
                id: kuva
                source: "../../images/kivitex1s.png"
            }
    }
    DrawMesh {
        Clear {
            cR: 1.0; cG: 0.0; cB: 0.0
        }

        property string name: "PillarMan"
        //file: "mesh/pillarman.dae"
        file: "mesh/pillarman.obj"
        Rot { d: -235.0; ax: 0.10; ay: 1.0; az: 0.0; }
        Sca { s: 6.0 }
        // file: "mesh/pillarmanb.x"
      //  file: "mesh/aivob.x"
    }

    Image {
        id: adaptOvl
        visible: bSceneEnabled
         anchors.fill: parent
      //  width: windowWidth
      //  height: windowHeight
        source: "../../images/adapt_logo2_full.png"
    }



    Blit {
        textureRT: "blitti"
    }

    Texture {
        textureRT: "blitti"
        textureUnit: 0
    }
    Texture {
        textureItem: adaptOvl
        textureUnit: 1
    }

    Shader {
        file: sceneDir+"blit"
    }
    DrawVB {
        type: "quad"
    }

//    DrawItem {
//        itemId: adaptOvl
//    }


    Blit {
        textureRT: "prevScreen"
    }

/*
    DrawOverlaySub {
        file: "scrolltex4.png"
        overlayAlpha: 0.20
    }

    DrawOverlayScreen {
        file: "tornistab.png"
        overlayAlpha: 0.0
 //       drawEnabled: false
    }
*/

//    DrawOverlay {
//        file: "ovl_go_deepr.png"
//    }

//    DrawOverlay {
//        file: "ovl_go_deepr.png"
//    }

}
