import QtQuick 2.3

import "../" // to import RocketScene

import AdaptDemoSystem 1.0



RocketScene {

    sceneName: "SkenePulloharja"

    ClearRT {
        cR: 0.0; cG: 0.0; cB: 0.0; cA: 1.0
    }


    Camera {
        property string name: "camera"
        x: sync(name + ".x")
        y: sync(name + ".y")
        z: sync(name + ".z")
        lookAtX: sync(name + ".lookAtX")
        lookAtY: sync(name + ".lookAtY")
        lookAtZ: sync(name + ".lookAtZ")
        upX: 0.0
        upY: 1.0
        upZ: 0.0
    }

    Shader {
        file: sceneDir+"sm"
    }
    SetTexture {
        file: "bokeh_housus.png"
    }

    DrawMesh {
        property string name: "mesh1"
        file: "mesh/aivob.x"
        Pos { x: 0; y: 0; z: 0 }
        Rot { d: 0.0; ax: 1.0; ay: 0.0; az: 0.0; cx: 0.0; cy: 0.0; cz: 0.0 }
        Sca { s: 1.0}
    }


}
