import QtQuick 2.3

import "../" // to import RocketScene

import AdaptDemoSystem 1.0



RocketScene {
    sceneName: "SkenePMZoom"

    anchors.fill: parent

    Image {
         anchors.fill: parent
      //  width: windowWidth
      //  height: windowHeight
        source: "../../images/adapt_logo2_full.png"
    }


    Camera {
        property string name: "camera"
        x: sync(name + ".x")
        y: sync(name + ".y")
        z: sync(name + ".z")
        lookAtX: sync(name + ".lookAtX")
        lookAtY: sync(name + ".lookAtY")
        lookAtZ: sync(name + ".lookAtZ")
        upX: 0.0
        upY: 1.0
        upZ: 0.0
    }

    Shader {
        file: sceneDir+"sm"
    }
    Texture {
        textureUnit: 0
        textureItem: kuva
            Image {
                visible: false
                // width: windowWidth
                //height: windowHeight
                // fillMode: Image.PreserveAspectFit
                id: kuva
                source: "../../images/kivitex1s.png"
            }
    }
    DrawMesh {
        property string name: "PillarMan"
        //file: "mesh/pillarman.dae"
        file: "mesh/pillarman.obj"
        // file: "mesh/pillarmanb.x"
      //  file: "mesh/aivob.x"
    }


    RenderTarget {
        RenderTargetLayer {
            textureRT: "blitti"
        }
    }
    Texture {
        textureRT: "blitti"
        blit: true
    }

    Shader {
        file: sceneDir+"blit"
    }
    DrawVB {
        type: "quad"
    }

}
