import QtQuick 2.3

import "../" // to import RocketScene

import AdaptDemoSystem 1.0



RocketScene {
    sceneName: "SkeneModernitsi"


    Camera {
        property string name: "camera"
        x: sync(name + ".x")
        y: sync(name + ".y")
        z: sync(name + ".z")
        lookAtX: sync(name + ".lookAtX")
        lookAtY: sync(name + ".lookAtY")
        lookAtZ: sync(name + ".lookAtZ")
        upX: 0.0
        upY: 1.0
        upZ: 0.0
    }

    Shader {
        file: sceneDir+"sm"
    }
    Texture {
        textureUnit: 0
        textureItem: kuva
        Image {
            id: kuva
            visible: false
            source: "../../images/kivitex1s.png"
        }
    }
    DrawMesh {
        property string name: "PillarMan"
        file: "mesh/pillarman.obj"
    }



    Image {
        opacity: sync("partycoding")
        id: partyLogo
        layer.enabled: true
        anchors.fill: parent
        source: "../../images/partycoding.png"
    }

    DrawItem {
        enabled: sync("partycoding") > 0.01 ? true : false
        flip: false
        itemId: partyLogo
    }

}
