#version 430



vec4 rotateXZ(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  return r;
}

vec3 rotateXZ3(vec3 p, float a) {
  return rotateXZ(vec4(p, 0.0), a).xyz;
}

vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec4 rotateYZ(vec4 p, float a) {
  vec4 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}

layout(triangles) in;
layout(triangle_strip, max_vertices = 15) out;
//layout(line_strip, max_vertices = 15) out;

in vec3 normal[3];
in vec2 uv[3];
in vec3 tangent[3];
in vec4 origPos[3];

out vec4 posG;
out vec3 normalG;
out vec2 uvG;
out vec3 colorG;
out vec3 tangentG;
 
uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;

uniform float g_time;

uniform float windowWidth;
uniform float windowHeight;

layout(binding=0) uniform sampler2D tex;

void main(void) {

	float times = g_time*0.1;
       vec3 faceNormal = vec3(0.0);
	vec4 facePos = vec4(0.0);
	for (int i = 0; i < gl_in.length(); ++i) {
		gl_Position = gl_in[i].gl_Position; // -vec4(1.5, 0.0, 0.0, 0.0);
		facePos += origPos[i];
        //	gl_Position.xyz -= normal[i]*1.5;
		gl_Position = projectionMatrix * modelViewMatrix * gl_Position;
		normalG = normal[i];
		colorG = vec3(0.10, 0.2, 0.25);
		normalG = (modelViewMatrix * vec4(normalG, 0.0)).xyz;
		posG = gl_Position;
		faceNormal += normal[i];
		uvG = uv[i];
		tangentG = tangent[i];
                EmitVertex();
	}
	facePos /= 3.0;
        EndPrimitive();

        vec4 inp = facePos;
        // vec4 inp = ;
        float lim = -1.60;
        float why = 2.0*pow((clamp(sin((inp.y*0.31350-fract(inp.y*0.31350))+times*0.4)*1.0, lim, 1.0)-lim)/(1.0-lim),5.0);

        for (int i = 0; i < 3; ++i) {

                normalG = normal[i];

                // vec4 vertTex = texture2D(tex, uv[i]);
                // float hairLen = (vertTex.r+vertTex.g+vertTex.b)*0.33;
                vec4 modPos = origPos[i]*3.3;
                float modTime = g_time*2.2;

                float hairLen = 1.0; // sin(modPos.y+modPos.x+modTime)+cos(modPos.x*1.2+modPos.z+modTime)+2.0;

                gl_Position = gl_in[i].gl_Position;
                if (i==1) {
                  //gl_Position += vec4(0.0, 0.0, 0.0, 0.0);
                }
               // if (i==2) {
              //    gl_Position += vec4(normalG, 0.0)*why*hairLen*0.005;
                  gl_Position += vec4(faceNormal, 0.0)*why*hairLen*0.05;
               // }


             //  gl_Position.xyz -= normal[i].xyz*2.0;

//            gl_Position = gl_in[i].gl_Position;
////            //gl_Position.xyz -= normal[i].xyz*12.0*why;
//          //  gl_Position += rotateXZ(origPos[i], why*5.0);
//            gl_Position.xyz -= faceNormal*1.0*why;

                gl_Position = projectionMatrix * modelViewMatrix * gl_Position;
                colorG = mix(vec3(0.150, 0.150, 0.50),vec3(1.5,0.1,0.1), why*0.2)*0.20;
                normalG = (modelViewMatrix * vec4(normalG, 0.0)).xyz;
                uvG = uv[i];
                tangentG = tangent[i];
                posG = gl_Position;
         //       EmitVertex();
        }
        EndPrimitive();


}
