import QtQuick 2.3
import QtGraphicalEffects 1.0

Rectangle {
    width: windowWidth
    height: windowHeight


    Rectangle {
        anchors.fill: parent
        color: "black"
        opacity: 1.0
    }
//    MouseArea {
//        id: mouseArea
//        anchors.fill: parent

//        onClicked: {
//            Qt.quit();
//        }

//    }


    Rectangle {
        anchors.fill: parent
        anchors.bottomMargin: windowHeight*0.3
        anchors.topMargin: windowHeight*0.3
        color: "black"
    }
/*
    property real time: 0.0

    Component.onCompleted: {
        time = 10000.0
    }
    Behavior on time {
        NumberAnimation { duration: 10000*1000 }
    }


    Timer {
        id: chrono
        property real time: 0
        property int frames: 0
        property int fps: 0
        property int lastFrames: 0
        property real lastTime: 0
        running: true
        interval: 16
        repeat: true
        onTriggered: {
            time += 0.01667;
            frames++;
            if (parent.time-lastTime > 1.0) {
                fps = (frames-lastFrames)*60.0/61.0;
                lastFrames = frames;
                lastTime = parent.time;
            }
        }
    }
*/
//    Rectangle {
//        anchors.fill: parent
//        color: "black"
//    }

//    Text {
//        text: "FPS: "+chrono.fps.toFixed()
//        font.pixelSize: 30
//        anchors.fill: parent
//        color: "white"
//    }


    Image {
        opacity: 0.10
        anchors.fill: parent
        source: "../../images/bg_3.png"
    }

    Item {
        id: palikka
        anchors.fill: parent

        Image {
           // id: palikka
            fillMode: Image.PreserveAspectFit
            anchors.fill: parent
            source: "../../images/adapt_koho_2048.png"
          //  source: "../../images/_SK15231.JPG"
        }
    }

    Image {
    //    visible: false
        anchors.fill: parent
        id: flowMask
        fillMode: Image.Tile
        source: "images/flowmaskb.png"
    }

    ShaderEffectSource {
        id: flowMaskSrc
        sourceItem: flowMask
        hideSource: true
    }

    FastBlur {
        id: flowMaskBlur
        radius: 0
        anchors.fill: flowMask
        source: flowMask
    }
    ShaderEffectSource {
        id: flowMaskBlurSrc
        sourceItem: flowMaskBlur
        hideSource: true
    }


    ShaderEffectSource {
     //   recursive: true
        id: itemSrc
        sourceItem: palikka
        hideSource: true
    }
    ShaderEffectSource {
        recursive: true
        id: itemSrcPrev
        sourceItem: shaderi
    }

    Image {
    //    visible: false
        id: noiseImage
        source: "images/random16.png"
    }
    ShaderEffectSource {
     //   recursive: true
        id: noiseImageSrc
        sourceItem: noiseImage
        hideSource: true
        wrapMode: ShaderEffectSource.Repeat
    }

    ShaderEffect {
        id: shaderi
        width: palikka.width
        height: palikka.height
        anchors.centerIn: parent
        rotation: palikka.rotation
        property variant src: itemSrc
        property variant srcPrev: itemSrcPrev
        property variant srcNoise: noiseImageSrc
        property variant srcMask: flowMaskSrc
        property variant srcMaskBlur: flowMaskBlurSrc
        property real time: rocket.time-4.0
        vertexShader: "
            uniform highp mat4 qt_Matrix;
            attribute highp vec4 qt_Vertex;
            attribute highp vec2 qt_MultiTexCoord0;
            varying highp vec2 coordFS;
            void main() {
              coordFS = qt_MultiTexCoord0;
              gl_Position = qt_Matrix * qt_Vertex;
            }"
        fragmentShader: "
            varying highp vec2 coordFS;
            uniform sampler2D src;
            uniform sampler2D srcMask;
            uniform sampler2D srcMaskBlur;
            uniform sampler2D srcPrev;
            uniform sampler2D srcNoise;
            uniform lowp float qt_Opacity;
            precision highp float;
            uniform float time;


// from pouet raymarching thread by las of mercury
float perlin(vec3 p) {
    vec3 i = floor(p);
    vec4 a = dot(i, vec3(1., 57., 21.)) + vec4(0., 57., 21., 78.);
    vec3 f = cos((p-i)*3.14159265)*(-.5)+.5;
    a = mix(sin(cos(a)*a),sin(cos(1.+a)*(1.+a)), f.x);
    a.xy = mix(a.xz, a.yw, f.y);
    return mix(a.x, a.y, f.z);
}

float turb(vec3 c) {
        float r=0.0;
        float s=0.5;
        c*=0.010;
        // c.z *= 0.1;
        for (int i=0;i<5;i++) {
                //if (i<2) continue;
                // r+=s*0.5*(perlin(c)*1.0+0.0*perlin(vec3(c.xy, 0.5-c.z)));
                r += s*0.5*((texture2D(srcNoise, c.xy+vec2(0.1231,1.23123)*c.z)+texture2D(srcNoise, c.xy*1.21-vec2(1.21231,0.123123)*c.z))*3.0-1.50);
                c*=3.0;
                //c.z *= 2.0;
                s*=0.55;
        }
        return r;
}


vec2 rotateXY(vec2 p, float a) {
  vec2 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

        vec3 tonemapUC2(vec3 x) {
            float A = 0.15;
            float B = 0.50;
            float C = 0.10;
            float D = 0.20;
            float E = 0.02;
            float F = 0.30;
            return ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F;
        }

       vec2 getBump(sampler2D sampler, vec2 texCoord) {
            vec2 ofsX = vec2(1.0/1280.0, 0.0)*1.0+vec2(0.5/1280.0, 0.0)*1.0;
            vec2 ofsY = vec2(0.0, 1.0/720.0)*1.0+vec2(0.0, 0.5/720.0)*1.0;
            float texX = texture2D(sampler, texCoord+ofsX.xy).g;
            float texY = texture2D(sampler, texCoord+ofsY.xy).g;
            float texBumpBrightX = texture2D(sampler, texCoord-ofsX.xy*1.0).g;
            float texBumpBrightY = texture2D(sampler, texCoord-ofsY.xy*1.0).g;
            vec2 result = vec2(texX-texBumpBrightX, texY-texBumpBrightY);
            return result;
       }

        float aTanSafe(float y, float x) {
         float ret;
            if (x!=0.0) {
                if (x>0.0) {
                    ret=atan(y/x);
                } else	{
                    ret=atan(y/x)+3.141592;
                }
            } else	{
                if (y>=0.0) {
                    ret=0.5*3.141592;
                } else {
                    ret=-0.5*3.141592;
                }
            }
         return ret;
        }


            void main() {

              vec2 coord = coordFS;
              vec4 tex = texture2D(src, coord);
              vec4 texPrev = texture2D(srcPrev, coord);
              vec2 coordC = (coord-vec2(0.5,0.5))*0.10;
//              vec3 res = vec3(1.0, 1.0, 1.0);
//              for (int i=0; i<1; i++) {
//                res.r *= 0.50+sin(coordC.x*32.0*(i*0.01+1.0)+30.0*coordC.y*(i*0.1+1.0)*cos(i*0.123+time)+i*123.1+time)+cos(coordC.y*28.0*(i*0.01+1.0)*1.141+30.0*coordC.x*sin(i*2.123+time)+i*0.23043+time*0.123);
//                res.g *= 0.50+sin(coordC.x*31.50*(i*0.01+1.0)+30.0*coordC.y*(i*0.1+1.0)*cos(i*0.123+time)+i*123.1+time)+cos(coordC.y*28.0*(i*0.01+1.0)*1.141+30.0*coordC.x*sin(i*2.123+time)+i*0.23043+time*0.123);
//                res.b *= 0.50+sin(coordC.x*31.0*(i*0.01+1.0)+30.0*coordC.y*(i*0.1+1.0)*cos(i*0.123+time)+i*123.1+time)+cos(coordC.y*28.0*(i*0.01+1.0)*1.141+30.0*coordC.x*sin(i*2.123+time)+i*0.23043+time*0.123);
//                coordC *= (i*0.01+1.0);
//              }
//              // res *= 100.0;
//              res += 0.0;
//              res += texture2D(srcPrev, coord);
//              res /= 1;
//              tex.r *= res.r;
//              tex.g *= res.g;
//              tex.b *= res.b;
              coordC *= 8.0;
              float mt = 0.002+0.001*(1.0-texPrev.g);
              // float td = clamp(time, 0.0, 1.0)*0.9999*clamp(cos(coordC.x*3.0+(tex.g+texPrev.g)*0.3-time*0.82)*1.0+1.50, 0.0, 1.0);
              float td = clamp(time, 0.0, 1.0)*min((0.75+0.5*cos(time*0.3)), 0.999);
              // td *= 1.0-clamp((time-3.0)*0.2, 0.0, 1.0);
              float noiseBoostTex = 0.0;
              tex *= 1.00-noiseBoostTex*0.5+noiseBoostTex*rand(coordC);
              tex *= 1.0-td*1.0;
              float tslap = -0.070;
            //  float turbZ = turb(vec3(coordC, time*tslap))*0.01*1.0;
              coord = (coord-vec2(0.5, 0.5))*(1.0)+vec2(0.5, 0.5);
              float chromaBoost = 1.13;
              float chromaBoostR = 1.03;
              float chromaBoostM = 1.0;
              float noiseBoost = 0.10;
              td *= 1.00-noiseBoost*0.5+noiseBoost*rand(coordC);
             // td *= 1.04;
              // vec2 coordOfs = coord+vec2(0.0+mt*turb(vec3(coordC.x+time*tslap*1.1, coordC.y, time*tslap)), mt*turb(vec3(coordC.y*1.23+time*tslap*0.61, coordC.x*0.82, time*tslap)));
              vec2 coordOfs;
              vec2 coordWO;
              float rm = 2.0;
              float tm = 1.0;

              vec2 pixOfsX = vec2(1.0/1280.0, 0.0/720.0);
              vec2 pixOfsY = vec2(0.0/1280.0, 1.0/720.0);
              vec2 korj = 0.0*vec2(0.5/1280.0, 0.5/720.0);


              // vec3 bumpi = vec3(getBump(srcMask, coordWO)*22.0, 1.0);
              // bumpi = normalize(bumpi);
              // coordOfs = coordOfs*bumpi.z-bumpi.xy*0.0*(1.0-bumpi.z);

              vec3 texP = vec3(0.0);

//coord.y -= 0.01;

              float div = 0.0;
              for (int j=-1; j<=1; j++) {
                  for (int i=-1; i<=1; i++) {
                      float turbAng = turb(vec3((coordC+pixOfsX*float(i)+pixOfsY*float(j))*tm, time*tslap));
                      coordOfs = 1.0*rotateXY(vec2(1.0, 0.0), rm*3.141592*turbAng*1.0);
                      // coordOfs.y -= 1.0;
                      // coordOfs = normalize(coordOfs);

                      vec2 pixOfs = vec2(i, j) - coordOfs;
                      float pixDist = clamp(1.0-sqrt(dot(pixOfs, pixOfs)), 0.0, 1.0)*1.0;

                      coordWO = coord+coordOfs*mt*0.50-korj;
                      vec4 mask = texture2D(srcMask, coordWO+0.0*pixOfsX*float(i)+0.0*pixOfsY*float(j));
                      if (mask.r < 0.01) {
                        texP.rgb += texture2D(srcPrev, coordWO+pixOfsX*float(i)+pixOfsY*float(j)).rgb*td*pixDist;
                        div += 1.0;
                      } else {

//                        if (i==0 && j==0) {
//                            texP.rgb = texture2D(srcPrev, coord)*pixDist*1.5;
//                        }
//                        else {
                      //      coord.y += 0.02;
                              vec3 bumpi = vec3(getBump(srcMaskBlur, coordWO+pixOfsX*float(i)+pixOfsY*float(j))*1.0, 1.0);
                           //   bumpi = normalize(bumpi);
                            // texP.rgb += mask.r*bumpi
                          //  texP.rgb += texture2D(srcPrev, coordWO+pixOfsX*i+pixOfsY*j).rgb*td*(1.0-mask.r)*(1.0-mask.r);
                          //    div += (1.0-mask.r)*(1.0-mask.r);

                      coordOfs = 1.0*rotateXY(vec2(1.0, 0.0), rm*3.141592*turbAng*1.0);
                            float kb = 6.0;
                           //   bumpi.xy = rotateXY(bumpi.xy, -0.25*aTanSafe(-coordOfs.y+bumpi.y*kb, -coordOfs.x+bumpi.x*kb));


                              coordOfs += bumpi.xy*10.0;
                              coordWO = coord+coordOfs*mt-korj;
                            texP.rgb += texture2D(srcPrev, coordWO+pixOfsX*float(i)+pixOfsY*float(j)).rgb*td*pixDist;
                     //    }
                      }
                  }
              }
           //   texP /= div;

//                              vec3 bumpi = vec3(getBump(srcMaskBlur, coord)*1.0, 1.0);
//                              bumpi = normalize(bumpi)*2.0;

// texP.rgb = bumpi;

/*
              vec4 mask = texture2D(srcMask, coordWO);

              if (mask.r < 1.0) {
                texP.rgb = texture2D(srcPrev, coordWO).rgb*td;
              } else {
//                coord.y += 0.02;

                mask = texture2D(srcMaskBlur, coordWO);


              vec3 bumpi = vec3(getBump(srcMaskBlur, coord), 1.0);
              bumpi = normalize(bumpi);

                float bumpAng = aTanSafe(bumpi.y, bumpi.x);

              coordOfs =bumpi.xy*500.0;

              //  coordOfs = -bumpi*10.0; // rotateXY(vec2(1.0, 0.0), rm*3.141592*turbAng*0.0-bumpAng);
                coordWO = coord+coordOfs*mt*1.0*mask.r-korj+1.0*(1.0-mask.r)*mt*rotateXY(vec2(1.0, 0.0), rm*3.141592*turbAng*1.0);
                mask = texture2D(srcMask, coordWO);
                if (mask.r < 0.4) {
                     texP.rgb = 1.0*texture2D(srcPrev, coordWO).rgb*td;
                } else {
                    texP.rgb = 0.0*texture2D(srcPrev, coord).rgb*td;
                }
               // texP.rgb = vec3(bumpi.x, bumpi.y, 0.0);
              }

*/
            /*
              texP.r = texture2D(srcPrev, coordWO).r*td;
              mt *= chromaBoost;
              rm *= chromaBoostR;
              tm *= chromaBoostM;
              coordOfs = rotateXY(vec2(1.0, 0.0), rm*3.141592*turb(vec3(coordC.x*tm+time*tslap*1.1, coordC.y*tm, time*tslap)));
              coordWO = coord+coordOfs*mt;
              texP.g = texture2D(srcPrev, coordWO).g*td;
              mt *= chromaBoost;
              rm *= chromaBoostR;
              tm *= chromaBoostM;
              coordOfs = rotateXY(vec2(1.0, 0.0), rm*3.141592*turb(vec3(coordC.x*tm+time*tslap*1.1, coordC.y*tm, time*tslap)));
              coordWO = coord+coordOfs*mt;
              texP.b = texture2D(srcPrev, coordWO).b*td;
*/
              //texP *= 0.98;
              texP.r *= 1.032;
              texP.g *= 1.01;
              texP.b *= 0.99;

              tex.rgb += texP;
             // tex /= 1.0+td;
              tex.a = dot(tex.rgb, vec3(0.344, 0.5, 0.156));
              // gl_FragColor = vec4(vec3(dot(tex.rgb, vec3(0.344, 0.5, 0.156))), tex.a) * qt_Opacity;

            vec3 color = tex.rgb;
//        float vignette = clamp((1.0-sqrt(dot(coordC, coordC))*1.350), 0.0, 1.0)+rand(coord)*0.025*0.0;
//        vignette *= vignette;
//        color *= vignette;
//        color.rgb = tonemapUC2(color.rgb*3.0);
//        color = pow(color, 0.50*1.30)*1.50;
//        color = clamp(color, 0.0, 1.0);


            //    color = texture2D(srcMaskBlur, coord);
                // color.r = 1.0;
              gl_FragColor = vec4(color, tex.a) * qt_Opacity;
            }



"
    }

    Image {
        anchors.fill: parent
        source: "../../images/credits.png"
    }

    Rectangle {
        anchors.fill: parent
        color: "white"
        opacity: sync("fireMask")
    }

    Rectangle {
        anchors.fill: parent
        color: "black"
        opacity: sync("fadeToBlack")
    }
}
