import QtQuick 2.3

import "../" // to import RocketScene

import AdaptDemoSystem 1.0



RocketScene {
    sceneName: "SkeneApinaAivo"


    ClearRT {
        cR: 0.0; cG: 0.0; cB: 0.0; cA: 1.0
        clearAmount: sync("clear")
    }


//    RenderTarget {
//        RenderTargetLayer {
//            textureRT: "rtPinta1_0" // name for how to access this texture in Texture item
//            Clear {
//                // clear color if cR, cG, cB or cA set here
//                cR: 0.0; cG: 0.0; cB: 0.0; cA: 1.0; // 0, 0, 0, 1 is default clear color

//                // clear depth if cD set here
//                cD: 1.0; // 1.0 is default clear depth
//            }
//        }

//    }
    Camera {
        property string name: "camera"
        x: sync(name + ".x")
        y: sync(name + ".y")
        z: sync(name + ".z")
        lookAtX: sync(name + ".lookAtX")
        lookAtY: sync(name + ".lookAtY")
        lookAtZ: sync(name + ".lookAtZ")
        upX: 0.0
        upY: 1.0
        upZ: 0.0
    }

    Shader {
        file: sceneDir+"sm"
        tfVaryings: "posG,normalG,uvG,tangentG"
    }
    Texture {
        textureUnit: 0
        textureItem: kuva
        Image {
            id: kuva
            visible: false
            source: "../../images/zeppo_plate4s.png"
        }
    }
    DrawMesh {
        property string name: "mesh2"
        file: "mesh/apehead.obj"
        ShaderParam {
            paramName: "g_exploWeight"
            paramValue: sync("exploWeight")
        }
        Sca { s: sync("apeScale") }
    }

    Blit {
        textureRT: "rtApina"
    }


    Texture {
        textureUnit: 0
        textureRT: "rtApina"
    }
    Shader {
        file: sceneDir+"ssPart"
    }
//    DrawMesh {
//        property string name: "mesh2"
//        file: "mesh/apehead.obj"
//    }

    DrawVB {
        type: "pointGrid"
        gridWidth: windowWidth/4
        gridHeight: windowHeight/4
        depthTest: false
        depthWrite: false
        ShaderParam {
            paramName: "g_pikselos"
            paramValue: sync("pikselos")
        }
    }

//    Shader {
//        file: sceneDir+"sm"
//    }
//    Texture {
//        textureUnit: 0
//        textureItem: kuva
//        Image {
//            id: kuva
//            visible: false
//            source: "../../images/kivitex1.png"
//        }
//    }
//    DrawMesh {
//        property string name: "mesh2"
//      //  file: "mesh/apehead.obj"
//        file: "mesh/uvtest.obj"
//      //  file: "mesh/kolkkus_inf.x"
//      //  file: "mesh/hand1b.x"
//      //  file: "mesh/scityfly.x"
//    }


    Shader {
        file: sceneDir+"plastic"
    }
    Texture {
        textureUnit: 0
        textureRT: "rtPinta1_0"
    }
    DrawMesh {
        property string name: "cube"
        file: "mesh/aivob.x"
        Pos { x: sync("aivoX"); y: sync("aivoY") }
        Sca { s: sync("aivoScale")*0.1*sync("apeScale")+0.0 }
    }


    SetTexture {
        textureUnit: 0
        file: "1234567_3.jpg"
    }
    SetTexture {
        textureUnit: 1
        file: "hair1.png"
    }

    Shader {
        file: sceneDir+"smExplos"
    }

    property real hcx: 0.0
    property real hcy: 0.0
    property real hcs: 1.0

    Repeater {
        model: 8
        delegate:
        DrawMesh {
            property string name: "longhand1"
            file: "mesh/longhand1.x"
            ShaderParam {
                paramName: "g_exploWeight"
                paramValue: sync("longhand1.exploWeight")
            }
            Pos { y: -hcy*1.650; }
            Pos { x: -hcx*0.80; }
            Rot { d: index*sync("kasiDiff")+sync("kasiRot"); ax: 0.0; ay: 0.0; az: 1.0; }
            Pos { y: hcy*1.650; }
            Pos { x: hcx*0.80; }
            Pos { x: sync("aivoX"); y: sync("aivoY")-3.5+(1.0-sync("kasi"))*3.5 }
            Sca { s: hcs*20.0*sync("apeScale"); y: sync("kasi") }
        }
    }


    Repeater {
        model: 8
        delegate:
        DrawMesh {
            property string name: "longhand1"
            file: "mesh/longhand1.x"
            ShaderParam {
                paramName: "g_exploWeight"
                paramValue: sync("longhand1.exploWeight")
            }
            Pos { y: -hcy; }
            Pos { x: -hcx; }
            Rot { d: -index*sync("kasiDiff")+sync("kasiRot"); ax: 0.0; ay: 0.0; az: 1.0; }
            Pos { y: hcy; }
            Pos { x: hcx; }

            Pos { x: sync("aivoX"); y: sync("aivoY")-3.5+(1.0-sync("kasi"))*3.5 }
            Sca { s: hcs*10.0*sync("apeScale"); y: sync("kasi") }
        }
    }


    Group {
        enabled: sync("mirrorEnabled") > 0.5 ? true: false
        Blit {
            textureRT: "blitti"
        }
        Texture {
            textureRT: "blitti"
            textureUnit: 0
        }
//        Texture {
//            textureItem: adaptOvl
//            textureUnit: 1
//        }
        Shader {
            file: sceneDir+"blitMirror"
        }
        DrawVB {
            type: "quad"
        }
    }

}
