#version 430



vec4 rotateXZ(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  return r;
}

vec3 rotateXZ3(vec3 p, float a) {
  return rotateXZ(vec4(p, 0.0), a).xyz;
}

vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec4 rotateYZ(vec4 p, float a) {
  vec4 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}

layout(triangles) in;
layout(triangle_strip, max_vertices = 15) out;
//layout(line_strip, max_vertices = 15) out;

in vec3 normal[3];
in vec2 uv[3];
in vec3 tangent[3];
in vec4 origPos[3];

out vec4 posG;
out vec3 normalG;
out vec2 uvG;
out vec3 colorG;
out vec3 tangentG;
 
uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;

uniform float g_time;

uniform float windowWidth;
uniform float windowHeight;

void main(void) {

	float times = g_time*0.1;
       vec3 faceNormal = vec3(0.0);
	vec4 facePos = vec4(0.0);
	for (int i = 0; i < gl_in.length(); ++i) {
		gl_Position = gl_in[i].gl_Position; // -vec4(1.5, 0.0, 0.0, 0.0);
		facePos += origPos[i];
        //	gl_Position.xyz -= normal[i]*1.5;
		gl_Position = projectionMatrix * modelViewMatrix * gl_Position;
		normalG = normal[i];
		colorG = vec3(0.10, 0.2, 0.25);
		normalG = (modelViewMatrix * vec4(normalG, 0.0)).xyz;
		posG = gl_Position;
		faceNormal += normal[i];
		uvG = uv[i];
		tangentG = tangent[i];
                EmitVertex();
	}
	facePos /= 3.0;

	EndPrimitive();
	

}
