import QtQuick 2.3
import QtGraphicalEffects 1.0

import "../" // to import RocketScene

import AdaptDemoSystem 1.0


RocketScene {

    sceneName: "Skene1"

    Camera {
        property string name: "camera"
        x: sync(name + ".x")
        y: sync(name + ".y")
        z: sync(name + ".z")
        lookAtX: sync(name + ".lookAtX")
        lookAtY: sync(name + ".lookAtY")
        lookAtZ: sync(name + ".lookAtZ")
        upX: 0.0
        upY: -1.0
        upZ: 0.0
    }

    Shader {
        file: sceneDir+"sm"
    }
    Texture {
        textureUnit: 0
        textureItem: kuva
        Image {
            id: kuva
            visible: false
            source: "../../images/kivitex1.png"
        }
    }
    DrawMesh {
        enabled: true
        property string name: "mesh1"
        file: "data/aivob.x"

        Pos { x: 0; y: 0; z: 0 }
        Rot { d: 0.0; ax: 1.0; ay: 0.0; az: 0.0; cx: 0.0; cy: 0.0; cz: 0.0 }
        Sca { s: 4.0 }
    }

    Shader {
        file: sceneDir+"sm"
    }
    Texture {
        textureUnit: 0
        textureItem: imaget
        Item {
            id:imaget
            layer.enabled: true
            visible: false
            width: windowWidth
            height: windowHeight
            Image {
                anchors.fill: parent
                source: "../../images/_SK14607_scaled.jpg"
                //source: "../../images/adapt_logo2_fulla.png"
            }
            Text {
                x: 0.0// Math.sin(time)*500.0
                y: 100+Math.sin(time*1.3)*100.0
                // rotation: time
                text: "Set this property to wrap the text to the Text item's width. The text will only wrap if an explicit width has been set. wrapMode can be one of \n
*Text.NoWrap (default) - no wrapping will be performed. If the text contains insufficient newlines, then contentWidth will exceed a set width.
*Text.WordWrap - wrapping is done on word boundaries only. If a word is too long, contentWidth will exceed a set width.
*Text.WrapAnywhere - wrapping is done at any point on a line, even if it occurs in the middle of a word.
*Text.Wrap - if possible, wrapping occurs at a word boundary; otherwise it will occur at the appropriate point on the line, even in the middle of a word."
                wrapMode: Text.WordWrap
                font.pixelSize: 30
                color: "white"
            }
        }
    }
    DrawMesh {
        property string name: "meshHand"
        file: "mesh/hand1b.x"
    //    file: "mesh/skull.obj"
        Sca { x: 10.0; y: 10.0; z: 10.0 }
    }


//    Shader {
//        file: sceneDir+"blit"
//    }

//    DrawVB {
//        type: "quad"
//    }


    Texture {
        textureUnit: 0
        textureItem: tekstuuri
        Image {
            id: tekstuuri
            visible: false
            source: "../../images/adapt_logo2_fulla.png"
        }
    }

    DrawMesh {
        enabled: false
        property string name: "mesh2"
        file: "data/apehead.obj"

        ShaderParam {
            paramName: "furLength"
            paramValue: sync(parent.name + ".furLength")
        }

        Pos {
            x: sync(parent.name + ".x")
            y: sync(parent.name + ".y")
            z: sync(parent.name + ".z")
        }
        Sca { x: 0.30; y: 1.0; z: 1.0 }
    }

    DrawMesh {
        enabled: false
        property string name: "mesh3"
        file: "data/apehead.obj"
    }

}
