#version 430

layout(binding=0) uniform sampler2D srcBg;
layout(binding=1) uniform sampler2D src;

in vec2 uv;

layout(location = 0) out vec4 frag;
// layout(location = 1) out vec4 frag2;

uniform float g_time;

precision highp float;
varying highp vec2 coord;

uniform float rayX=0.5;
uniform float rayY=0.5;

uniform float lightZ = 2.0;
uniform float g_intensity = 1.0;
uniform float g_specRounds = 2.0;
uniform float g_specWeight = 1.5;



 vec4 spreadSpec(vec4 c, float sp) {
     vec4 res;
     //res.r = mix(c.r, 0.0, (1.0-sp)*1.0);
     //res.g = mix(c.g, 0.0, abs((sp-0.5)*2.0));
     //res.b = mix(c.b, 0.0, sp*1.0);

     sp = fract(sp);

     res.r = smoothstep(1.0, 0.0, (1.0-sp)*1.0)*c.r;
     res.g = smoothstep(1.0, 0.0, abs((sp-0.5)*2.0))*c.g;
     res.b = smoothstep(1.0, 0.0, sp*1.0)*c.b;

//            float widthM = 1.50;
//            float width = 1.0/(widthM/2.0);
//            sp = -widthM/2.0+sp*(1.0+widthM/2.0);
////            c.b *= 0.3;
////            c.g *= 0.6;
////            c.r *= 1.0;
//            res.b = smoothstep(1.0, 0.0, abs((sp-0.0)*width))*c.b+smoothstep(1.0, 0.0, abs((sp-1.5)*width))*c.b;
//            res.g = smoothstep(1.0, 0.0, abs((sp-0.5)*width))*c.g;
//            res.r = smoothstep(1.0, 0.0, abs((sp-1.0)*width))*c.r+smoothstep(1.0, 0.0, abs((sp-(-0.5))*width))*c.r;

     res.a = c.a;
     return res;
 }

 vec3 tonemapUC2(vec3 x) {
     float A = 0.15;
     float B = 0.50;
     float C = 0.10;
     float D = 0.20;
     float E = 0.02;
     float F = 0.30;
     return ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F;
 }

 vec3 tonemap(vec3 color, float brightness) {
     color.xyz = pow(color.xyz, vec3(1.0))*brightness;
     color = color*(1.0+color/4.0)/(1.0+color);
     return color;
 }
 float aTanSafe(float y, float x) {
  float ret;
     if (x!=0.0) {
         if (x>0.0) {
             ret=atan(y/x);
         } else	{
             ret=atan(y/x)+3.141592;
         }
     } else	{
         if (y>=0.0) {
             ret=0.5*3.141592;
         } else {
             ret=-0.5*3.141592;
         }
     }
  return ret;
 }

// google glsl rand gave this, thanks and credit flies to
// http://stackoverflow.com/questions/4200224/random-noise-functions-for-glsl
float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

void main() {
    vec4 tex = texture2D(src, coord);
    vec4 texBg = texture2D(srcBg, coord);
    vec3 bright = vec3(dot(tex.rgb, vec3(0.344, 0.5, 0.156)));
    vec4 color = pow(tex,vec4(1.0))*0.0;
         //lowp vec2 center = vec2(0.5, 0.5);
         vec2 center = vec2(rayX*1.0+0.5, rayY*1.0+0.5);
         float loops=48.0;
         float loopsSub=4.0;
//                lowp float kx = 0.06;
//                lowp float ky = 0.17;
//                lowp vec2 center1 = center+vec2(0.0,ky);
//                lowp vec2 center2 = center+vec2(0.0,-ky);
//                lowp vec2 center1x = center+vec2(kx, 0.0);
//                lowp vec2 center2x = center+vec2(-kx, 0.0);
//            for (int i=4; i<loops; i++) {
//                lowp float sp = i/loops;
//                lowp float spp = 1.0-sp;
//                spp = spp;
//                lowp vec2 coordC = (coord-center1)*spp+center1;
//                lowp vec2 coordC2 = (coord-center2)*spp+center2;
//                lowp vec2 coordCx = (coord-center1x)*spp+center1x;
//                lowp vec2 coordC2x = (coord-center2x)*spp+center2x;
//                lowp vec4 piste = (texture2D(src, coordC)+texture2D(src, coordC2))*0.25;
//                piste += (texture2D(src, coordCx)+texture2D(src, coordC2x))*0.25;
//                color += spreadSpec(piste,sp)*0.9+piste*0.1;
//            }
//            // scaling version
//            for (int i=0; i<loops; i++) {
//                lowp float sp = i/loops;
//                sp = sp;
//                lowp float spp = 1.0-sp*1.0;
//                //spp = spp*1.0;
//                //lowp vec2 ofs = vec2(0.01*sin(sp*11.101),0.010*cos(sp*12.20132));
//                lowp vec2 coordC = (coord-center)*spp+center;
//                lowp vec4 piste = (texture2D(src, coordC));
//                //piste += (texture2D(src, coordCx)+texture2D(src, coordC2x))*0.5;
//                //piste *= 0.50;
//                color += spreadSpec(piste, sp)*0.5+piste*0.5;
//            }

     //raymarch version
     float eyeZ = 0.02;
     vec2 coordCen = coord-vec2(0.5, 0.5);
     vec3 eyeDir = vec3((coord-vec2(0.5, 0.5))*eyeZ*1.0, eyeZ);
     vec3 ray=eyeDir;
     vec3 image=vec3(coord-vec2(0.5, 0.5), 1.0);
     vec3 lightPos=vec3((center-vec2(0.5, 0.5)), image.z+lightZ);


//            vec3 eyeToLight = lightPos-ray;
//            vec3 eyeAtImage = ray+vec3(eyeToLight.xy*(image.z-ray.z)/(lightPos.z-ray.z), image.z);
//            vec2 imagePos = vec2(eyeAtImage.xy+vec2(0.50,0.50));
//            float distCen = sqrt(dot(imagePos.xy, imagePos.xy));
//            loops = loops*0.0+distCen/1.414*(loops*1.0);

     //float radial=tan(lightPosC.y/lightPosC.x);
     float radial=1.0;
     vec4 colorPiste = vec4(0.0);
     float staticOfs = (rand(coord+vec2(0.3,0.476)*(0.0)+vec2(0.123,0.172)*g_time*0.0)-0.5);
     vec4 colorNow = vec4(0.0);
     vec4 colorPrev = vec4(0.0);
     vec4 colorPrev2 = vec4(0.0);
     vec3 eyeToLight;
     vec3 eyeAtImage;
     vec2 imagePos;
     float distCen = sqrt(dot(coordCen-center+vec2(0.5,0.5), coordCen-center+vec2(0.5,0.5)));

     for (float i=0.0; i<loops; i++) {
         lowp float sp = i/(loops-1.0);
         //sp = pow(sp, 0.750);
         eyeToLight = lightPos-ray;
         eyeAtImage = ray+vec3(eyeToLight.xy*(image.z-ray.z)/(lightPos.z-ray.z), image.z);
         imagePos = vec2(eyeAtImage.xy+vec2(0.50,0.50));
         //distCen = sqrt(dot(imagePos.xy, imagePos.xy));
         //float kooba = sin(ray.x*11.2+3.3*cos(ray.y*6.8))+cos(ray.y*12.3+ray.z*16.2);
         //radial = sin(aTanSafe(eyeToLight.y,eyeToLight.x)*700.0)*0.02+0.98;
         //radial = sin(atan(eyeToLight.y/eyeToLight.x)*600.0)*0.05+0.95;
         //radial = 1.0;
        // float radial2 = sin(aTanSafe(eyeToLight.y,eyeToLight.x)*850.0);
         vec4 piste = vec4(texture2D(src, imagePos).r)*radial;


         piste = piste;
         piste = clamp(piste*g_intensity, 0.0, 100.0);

         colorNow = spreadSpec(piste, sp*g_specRounds+0.0)*g_specWeight+piste*1.0;
         //colorNow.rgb = piste.rgb*1.0;
         //colorNow.a = sp*piste.b;

//                vec3 eyeToLight2 = (lightPos-ray)+(lightPos-ray)*0.40;
//                float eyeToLightD = sqrt(dot(eyeToLight2, eyeToLight2))-0.0*sqrt(dot(eyeToLight2, eyeToLight2));
//                vec3 eyeAtImage2 = ray+vec3(eyeToLight2.xy*(image.z-ray.z)/(lightPos.z-ray.z), image.z);
//                vec2 imagePos2 = vec2(eyeAtImage2.xy+vec2(0.50,0.50));
//                vec4 piste2 = texture2D(src, imagePos2+vec2(0.0, 0.0))*radial;
//                vec4 colorNow2 = spreadSpec(piste2, sp*4.0+0.0);
//                loopsSub = 1.0;
//                for (int ii=0; ii<loopsSub; ii++) {
//                    float spSub = ii/loopsSub;
//                    spSub = fract(eyeToLightD*30.0);
//                    color += (colorNow*spSub+colorNow2*(1.0-spSub))/loopsSub;
//                    // color += sp*colorNow.r;
//                    //color += colorNow/loopsSub;
//                }
//                colorPrev2 = colorPrev;
//                colorPrev = colorNow;
         color += colorNow; //*(radial2*0.05+0.95);
         // colorPiste += piste;
         ray = eyeDir+(image-eyeDir)*(sp+1.0/loops*staticOfs);
     }
     //color = spreadSpec(color, color.a*0.2);
     color *= 1.0/(loops-1.0);
     color *= color*1.5;
     // colorPiste *= 1.0/loops;
     // colorPiste *= colorPiste*0.50;
     color.rgb += colorPiste.rgb+texBg.rgb*texBg.rgb;
     float vignette = clamp((1.0-sqrt(dot(coordCen, coordCen))*1.350), 0.0, 1.0)+rand(coord)*0.025;
     vignette *= vignette;
     color *= vignette;
     //color *= 0.5;
     //color = tonemap(color, 1.5);
     //color = pow(color, 1.5)*1.20;
     color.rgb = tonemapUC2(color.rgb*3.0);
     color = pow(color, vec4(0.50*1.30))*1.50;
/*
     color = pow(1.4*color,vec4(2.0));
     color *= 2.0;  // Hardcoded Exposure Adjustment
     lowp vec3 x = max(0,color-0.004);
     color = (x*(6.2*x+.5))/(x*(6.2*x+1.7)+0.06);
     color = pow(color, vec4(2.0))*1.05;
*/
   //  color.rgb = tex.rgb;

     gl_FragColor = vec4(color.rgb, 1.0);
}
