#version 330 core
in vec2 UV;
out vec4 opcolor;
uniform float gtime;

vec3 stripes(vec2 uv, float lscale, float dx, float thickness, float time){
    
    float anim = -1.0+2.0*smoothstep(-0.25, 0.25, sin(time*3.41));
    uv.x /= 1.3-clamp(uv.x+anim*tan(uv.y), 0.2, 1.0);
    uv.y /= 1.3-clamp(uv.y+anim*tan(uv.x), 0.2, 1.0);
    
    float wi = 2.0;//1.0*cos(time*3.0);
    float coord = uv.y + dx * uv.x - float(uv.x > 0.5) * wi * dx * (uv.x - 0.5);
    float c = float(mod(float(/*floor*/(coord / lscale + 1.0)), 2.0) > 2.0 - thickness);
    return vec3(c*0.91);
}

mat2 rotationMatrix(float angle){
    return mat2(cos(angle),-sin(angle),sin(angle),cos(angle));
}

vec3 sample(vec2 uv){
 	vec3 acc = vec3(0.0);
    const int p = 20;
    const float shutter = 0.015;
    float time = gtime-0.02;
    for(int i = 0; i < p; ++i){
        vec3 val = vec3(0.0);
        val += stripes(uv-vec2(.3/iResolution),.15+.1*sin(.3*time),sin(0.9*time),1.+.5*cos(1.7241*time), time);
    	val += stripes(uv+vec2(.3/iResolution),.15+.1*sin(.3*time),sin(0.9*time),1.+.5*cos(1.7241*time), time);
    	val += stripes(uv-vec2(.0,.3/iResolution.x),.15+.1*sin(.3*time),sin(0.9*time),1.+.5*cos(1.7241*time), time);
    	val += stripes(uv-vec2(.0,.3/iResolution.y),.15+.1*sin(.3*time),sin(0.9*time),1.+.5*cos(1.7241*time), time);
        acc += val;
        time += shutter/float(p);
    }
    return 0.1+0.9*clamp(acc/float(p)/4., 0.0, 1.0);
}

void main() {
	vec2 uv = rotationMatrix(-.15*gtime) * (UV - vec2(0.5));
    uv *= 1.0-0.07*abs(sin(gtime*6.82));
    uv += 0.5;
    vec3 color = sample(uv);
	opcolor = vec4(color, 1.0);
}