#ifdef GL_ES
    precision mediump float;
#endif

uniform float time;
uniform vec2 iResolution;
varying vec4 v_color;
varying vec2 v_texCoords;
uniform sampler2D u_texture;
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
uniform mat4 u_projTrans;
vec2 iMouse = vec2(cos(time),sin(time));






mat3 rotY(in float a){
    return mat3( cos(a), 0.0, sin(a),
                 0.0,    1.0, 0.0,
                -sin(a), 0.0, cos(a)
                );
}
mat3 rotX(in float a){
    return mat3( 1.0, 0.0, 0.0,
                 0.0, cos(a), sin(a),
                0.0, -sin(a), cos(a)
                );
}
mat3 rotZ(in float a){
    return mat3( 
                cos(a), sin(a), 0.0,
                -sin(a), cos(a), 0.0,
                0.0,0.0,1.0
                );
}
mat2 rotate(float Angle){
    mat2 rotation = mat2(
        vec2( cos(Angle),  sin(Angle)),
        vec2(-sin(Angle),  cos(Angle))
    );
    return rotation;
}
float udRoundBox( vec3 p, vec3 b, float r ){
  return length(max(abs(p)-b,0.0))-r;
}
float sdSphere( vec3 p, float s ){
  return length(p)-s;
}
float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}
float sdBox( vec3 p, vec3 b ){
  vec3 d = abs(p) - b;
  return min(max(d.x,max(d.y,d.z)),0.0) +
         length(max(d,0.0));
}
float udBox( vec3 p, vec3 b ){
    return length(max(abs(p)-b,0.0));
}
float pallo(vec3 pos, float size){
    return length(pos)-size;  
}
float sdPlane( vec3 p, vec4 n ){
  // n must be normalized
  return dot(p,n.xyz) + n.w;
}

float length2( vec2 p ) {
    return sqrt( p.x*p.x + p.y*p.y );
}

float length6( vec2 p ) {
    p = p*p*p; p = p*p;
    return pow( p.x + p.y, 1.0/6.0 );
}

float length8( vec2 p ) {
    p = p*p; p = p*p; p = p*p;
    return pow( p.x + p.y, 1.0/8.0 );
}
float sdTorus88( vec3 p, vec2 t ) {
  vec2 q = vec2(length8(p.zy)-t.x,p.x);
  return length8(q)-t.y;
}
float sdTorus82( vec3 p, vec2 t ) {
  vec2 q = vec2(length2(p.xz)-t.x,p.y);
  return length8(q)-t.y;
}



float sdCapsule( vec3 p, vec3 a, vec3 b, float r ) {
    p.y-=4.0;
    r+=p.y*p.y*.01;
    
    r+=1.3*texture2D(iChannel0,vec2((10./1024.)*3.141*atan(p.x,p.z)+time*.01,p.y*(8./1024.)+time*.1));

    vec3 pa = p - a , ba = b - a;
    float h = clamp( dot(pa,ba)/dot(ba,ba), 0.0, 1.0 );
    return length( pa - ba*h ) - r;
}
float calculateDistance(in vec3 p, out vec3 color, out float reflectiveValue) {
    vec3 rayPosition = vec3(p.xz, p.y).xzy;
    vec3 d = abs(rayPosition) - vec3(2.0, 0.0, -52.0);
    reflectiveValue=0.5;
    color = vec3(3.8, 1.0, 0.6);  
    float finalDistance = 10000000.;
    float dist1 = sdCapsule( p, vec3(0.,5.5,0.), vec3(0.,-15.5,0.), 0.03);
        
    dist1 = min(dist1,udBox(    p - vec3(0.0,-10.5,0.0), 
                                    vec3(
                                    100.0,length(p.xz*0.07)*length(p.xz*0.07)+
                                    5.0 +  texture2D(iChannel0,p.xz*0.01-time*0.001).r*0.2
                                    + 0.05 * ( 
                                                    sin(p.x+time*4.) + 
                                                    cos(p.z*1.1+time) + 
                                                    cos(p.z*0.8126+time*1.3) +
                                                    sin(p.x*0.1+time*0.5)*1.5 ), 
                                    100.0) )
                                    );
    
    if(finalDistance > dist1){
        finalDistance = dist1;
        color = 0.01*vec3(1., 1.2, 2.4)+texture2D(iChannel0,p.xz*12.1).rgb*0.1;
    }

    float dist2 = sdTorus82( p - vec3(0., -4.2, 0.), vec2(2.8,0.2));
    dist2 = min( dist2, sdTorus82( p - vec3(0., -6., 0.), vec2(5.,2.)));
    if (finalDistance > dist2) {
        finalDistance = dist2;
        color = vec3( 0.8, 0.2, 0.2)+texture2D(iChannel0,p.xz).rgb*0.1;
    }
    
    for(float i=0.0; i<4.0; i++)
        dist1 = min(dist1, udRoundBox( (p - vec3(sin(time)*0.2+1.0)*vec3(4.0*cos(time*0.7+i*11.0),2.5*sin(time*0.9+i*3.),4.0*sin(time*0.7+i*11.0))) * rotY(time+i) * rotX(time*1.6+i), vec3(0.5+0.35*sin(i+time)), 0.001));

    if (finalDistance > dist1) {
        finalDistance = dist1;
        color = vec3( 0.6, 0.2, 0.2);
    }
    return finalDistance;
}


float traceToLight(vec3 rayPosition, vec3 normalVector, vec3 lightSource){
    float epsilon = 0.01;
    vec3 rayStartPosition = rayPosition + normalVector*0.001;
    vec3 finalColor = vec3(0., 0., 0.);
    vec3 lightNormal = normalize(lightSource - rayPosition);
    float dist = 0.0;
    float lightAmount = 1.0;
        for(float i=0.; i<32.; i++) {
            rayPosition = rayStartPosition + dist * lightNormal;
            vec3 color;
            float dummy;
            float stepable = calculateDistance(rayPosition, color,dummy);
            dist += stepable;
            lightAmount = min(900.0*abs(stepable),lightAmount);
            if(length(rayPosition)>13.0)
                break;
        }
    return clamp(lightAmount,0.01,9.0);
}
vec3 tracer(vec3 rayStartPosition, vec3 rayDirection) {
    float epsilon = 0.05;
    
    vec3 rayPosition = rayStartPosition;

    vec3 normalVector;
    float dist = 0.0;
    vec3 returnColor = vec3(0.0);
    vec3 finalColor = vec3(0.0);
    vec3 lightSource = vec3(0.0,12.0,5.0);
    float reflectiveValue = 1.0;
    float reflectionNow = 1.0;
    float coff = 1.0;
    float finalLight = 1.0;
    
    float possibleFogLight = 1.0;
    
    for(float k=0.; k<3.; k++) {
        for(float i=0.; i<32.; i++) {
            vec3 color;
            float stepable = calculateDistance(rayPosition, color, reflectiveValue);
            dist += stepable;
            rayPosition = rayStartPosition + dist * rayDirection;
            
            if( length(rayPosition) > 40.)
                break;
            possibleFogLight -= 0.01;

            returnColor += 0.001*(1.0/length(rayPosition.xz-lightSource.xz));

            returnColor += vec3(0.1+time*0.0015,0.11+time*0.0011,0.2) * (1.0/length(rayPosition-lightSource)) * (-0.001*time+0.5);


            if( abs(stepable) <= epsilon){
                vec3 C;
                float dummy = 0.0;
                normalVector = vec3(    calculateDistance(rayPosition+vec3(epsilon,0,0),C,dummy)-
                                        calculateDistance(rayPosition+vec3(-epsilon,0,0),C,dummy),
                                        calculateDistance(rayPosition+vec3(0,epsilon,0),C,dummy)-
                                        calculateDistance(rayPosition+vec3(0,-epsilon,0),C,dummy),
                                        calculateDistance(rayPosition+vec3(0,0,epsilon),C,dummy)-
                                        calculateDistance(rayPosition+vec3(0,0,-epsilon),C,dummy));
                normalVector = normalize(normalVector);
                float light = traceToLight(rayPosition, normalVector, lightSource);
                finalLight = min(finalLight, light);
                float lightDistance = distance(rayStartPosition,lightSource);
                
                finalColor = color * vec3(dot(normalVector, -rayDirection));
                
                
                vec3 lightDir = (lightSource-rayPosition);
                lightDir = normalize(lightDir);
                float directLight = dot(normalVector, lightDir);
                reflectionNow = min(reflectionNow,reflectiveValue);
                
                finalColor+=max(pow(directLight,4.)*vec3(1.7,1.1,0.9),0.01)*reflectionNow;
                
                returnColor += ( vec3(finalLight) / (k*0.1/reflectionNow + 1.0)) * finalColor;
               
                break;
                
            }
        }
        dist = 0.1;
        rayStartPosition = rayPosition + normalVector;
        rayPosition = rayStartPosition;
        rayDirection = reflect(rayDirection, normalVector);
        coff *= 0.5;
    } 
    vec2 dir = vec2(atan(rayDirection.x,rayDirection.z)/3.14159+1.0,rayDirection.y*0.5+0.5);
    returnColor+=2.0*vec3(0.2-dir.y*dir.y*0.45) / (1.0/reflectionNow) - length(rayPosition.xz) * 0.002;
    return returnColor;
}

void main() {
    vec3 cameraPosition = vec3( sin(time), 0.6, -8.0-time*0.11);
    cameraPosition *= rotY((time)*2.5*0.40 );
    vec2 uv = 2.0 * gl_FragCoord.xy / iResolution.xy - 1.0;
    float aspect = iResolution.x / iResolution.y;
    if(abs(uv.y)>10.0/16.0){
        gl_FragColor = vec4(0.0,0.0,0.0,1.0);
    } else {
        vec3 direction = normalize(vec3(.5 * uv * vec2(aspect/2, 1.0), 1. )) ;
        direction *= rotY(time*2.5*0.40   );
        direction *= rotX(-0.1 );
        direction *= rotZ(time*0.01 );
    gl_FragColor = texture2D(u_texture,uv)*0.001  +  pow(vec4(tracer(cameraPosition, direction),1.1),1.6);
    }
}