#ifdef GL_ES
    precision mediump float;
#endif

uniform float time;
uniform vec2 iResolution;
varying vec4 v_color;
varying vec2 v_texCoords;
uniform sampler2D u_texture;
uniform mat4 u_projTrans;
vec2 iMouse = vec2(cos(time),sin(time));

#define N 16

float rand(vec2 co){
  return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

vec2 co(vec2 uv){
	// return sampler-compatible uv coords
    //uv.y = -uv.y; // Remove this if image is upside down (tends to happen with video)
	return 0.5-uv*0.49;
}

void main(void){
	vec2 uv = 1.0 - 2.0*(gl_FragCoord.xy / iResolution.xy);
	vec4 c = vec4(0.0);
	c.w = 1.0;
	
	float f = 1.0/float(N);
	for(int i = 0; i < N; ++i)
	{
		// sample texture
		c.x += f*texture2D(u_texture, uv*0.49-vec2(0.5) ).x;
		c.y += f*texture2D(u_texture, 1.012*uv*0.49-vec2(0.5) ).y;
		c.z += f*texture2D(u_texture, 1.019*uv*0.49-vec2(0.5) ).z;
		// distort radially
		uv /= 1.0 + ( f*(0.0125+0.001*sin(time*12.0)*rand(uv) ) );
	}
	// vignette and flicker
	//float v  = 1.5 / pow(1.0 + 0.05*dot(uv, uv), 5.0); 
	//float tv = 0.99+0.003*sin(60.0*time);
	gl_FragColor = c;
}