#ifdef GL_ES
    precision mediump float;
#endif

uniform float time;
uniform vec2 iResolution;
varying vec4 v_color;
varying vec2 v_texCoords;
uniform sampler2D u_texture;
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
uniform mat4 u_projTrans;
vec2 iMouse = vec2(cos(time),sin(time));
float roundBox(vec2 coord, vec2 pos, vec2 b, float c ){
  return 1.-floor(length(max(abs(coord-pos)-b,c)));
}
float circle(vec2 coord, vec2 pos, float size){
    return min(floor(distance(coord,pos)-size),0.);
}
float sdCapsule( vec2 p, vec2 a, vec2 b, float r ){
    vec2 pa = p - a, ba = b - a;
    float h = clamp( dot(pa,ba)/dot(ba,ba), 0.0, 1.0 );
    return min(floor(length( pa - ba*h ) - r),0.);
}
float circle(vec2 coord, vec2 pos, float size, float start, float end){
    float angle = atan(coord.x, coord.y);
    if(angle>start && angle<end) return 0.0;
    return min(floor(distance(coord,pos)-size),0.);
}
float repeat_circle(vec2 coord, vec2 pos, float size, float slice){
    float angle = atan(coord.x, coord.y);
    if(mod(angle * slice,3.141*2.0)<3.141) return 0.0;
    return min(floor(distance(coord,pos)-size),0.);
}
mat2 rotate(float Angle){
    mat2 rotation = mat2(
        vec2( cos(Angle),  sin(Angle)),
        vec2(-sin(Angle),  cos(Angle))
    );
	return rotation;
}

float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}
float triangle( vec2 coord, vec2 pos, float angle, float thick, float size){
    vec2 original_coord = coord;
    coord += pos;
    coord *= rotate(angle);
    float collision = 0.0;
    collision += sdCapsule( coord, vec2( 0.0, 0.333)*size, vec2( 0.3,-0.2)*size, thick );
    collision += sdCapsule( coord, vec2( 0.0, 0.333)*size, vec2(-0.3,-0.2)*size, thick );
    collision += sdCapsule( coord, vec2( 0.3,-0.2)*size, vec2(-0.3,-0.2)*size, thick );
    collision += 3.0*texture2D( iChannel0, original_coord * 0.6 + vec2(time*0.02) ).b * 0.5;
    collision += 2.5*texture2D( iChannel0, original_coord * 0.1 + vec2(time*0.001) ).b * 0.5;
    return -min(max(-collision,0.0),1.0);
}
vec3 bubble_effect(){
	vec2 p = gl_FragCoord.xy / iResolution.xy;
	float aspectCorrection = (iResolution.x/iResolution.y);
	vec2 coordinate_entered = 2.0 * p - 1.0;
	vec2 coord = vec2(aspectCorrection*0.5,1.0) *coordinate_entered;
    vec2 s = coord;
    float bubble_time = time - 4.0;
    coord *= rotate(-bubble_time*.163);
	vec3 COLOR =(vec3(0.9,0.4,0.5)
        		+vec3(0.2,0.5,0.2) );
    if(mod(coord.y*200.+coord.x*200.,8.)<1.1){
        COLOR -= vec3(0.05);
    }else if(mod(coord.y*200.-coord.x*200.,8.)<1.1){
        COLOR -= vec3(0.05);
    }
    coord /= 0.1*bubble_time*bubble_time;
    for(float i=0.0; i<22.0; i++){
        float final_I = i + max(bubble_time/32.0,0.0);
    	float Tfast = max(bubble_time*4.0 - final_I, 0.0) * 10.0;
        float bouncing = (0.5-0.5*cos(Tfast*.2)/(1.0+Tfast*Tfast*0.001));
        vec2 boxpos = texture2D(iChannel1, vec2(final_I/20.0,sin(final_I*.01))).xy-vec2(0.5);
        if(circle(coord, boxpos*(1.0+final_I*.5), bouncing*0.5*(1.0+final_I*.1))<0.0)
        COLOR += 0.1*vec3(1.5,0.5+0.41*sin(final_I),1.0+0.5*sin(final_I));
    }
    return COLOR;
}
void main(){
	vec2 p = gl_FragCoord.xy / iResolution.xy;
	float aspectCorrection = (iResolution.x/iResolution.y);
	vec2 coordinate_entered = 2.0 * p - 1.0;
	vec2 coord = vec2(aspectCorrection*0.5,1.0) *coordinate_entered;
    vec2 s = coord;
	float vignette = 1.0 / max(0.25 + 0.3*dot(coord,coord),1.);
    time = time;
    coord /= time*0.4;
	vec3 COLOR =(vec3(0.2,0.06,0.55)
        		+vec3(0.2,0.5,0.2) );
    if(mod(s.y*200.+s.x*200.,8.)<1.1){
        COLOR -= vec3(0.05);
    }else if(mod(s.y*200.-s.x*200.,8.)<1.1){
        COLOR -= vec3(0.05);
    }
    coord *= rotate(3.4 + time);
    float collision = 0.0;
    collision += 4.0 * circle( coord, vec2(0.0), 1.29);
    collision -= 4.0 * circle( coord, vec2(0.0), 0.9);
    collision += 4.0 * circle( coord, vec2(0.0), 0.45);
    
    if(collision<0.0 && (mod((p.x-p.y)*40.0,3.)<1.8) ){
        COLOR = vec3(0.16, 0.06, 0.3);
    }
    
    
    collision = 0.0;
    collision += 4.0 * circle( coord, vec2(0.0), 0.58);
    collision += 4.0 * repeat_circle( coord, vec2(0.0), 0.61, 10.0);
    collision -= 8.0 * circle( coord, vec2(0.0), 0.48);
    
    
    collision -= 2.0 * repeat_circle( coord, vec2(0.0), 1.5, 10.0);
    collision += 2.0 * repeat_circle( coord, vec2(0.0), 1.6, 5.0);
    
    if(collision<0.0 ){
        COLOR = vec3(1.0);
    }
    
    
    
    
    collision = 0.0;
    for( float i = 0.0; i < 30.0; i++){
        vec2 triangle_position = 2.0 * time * vec2( -0.5 + rand(vec2(i)) , -0.5 + rand( vec2(i*i) ) );
        collision += triangle( coord, triangle_position, time+i, 0.02 + 0.002*sin(time), sin(i+time) + 1.0);
    }
    ;
    if(collision<0.0){
        COLOR = vec3(1.0);
    }
    COLOR += 1.0 - min(time, 1.0);
    COLOR = COLOR * (1.0 - min(max(time-5.0,0.0),1.0) ) + bubble_effect()*min(max(time-5.0,0.0),1.0);
	gl_FragColor = texture2D(u_texture,p)*0.001  + vec4( COLOR*vignette
         				,1.0);
} 