/*
 * Decompiled with CFR 0.152.
 */
package Model;

import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.g3d.Environment;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelBatch;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import java.util.HashMap;
import java.util.Map;

public class ModelPack {
    private Array<ModelInstance> instances = new Array();
    private Array<String> filenames = new Array();
    private Map<String, Model> models;
    private AssetManager assets = new AssetManager();
    private boolean loading = false;

    public ModelPack() {
        this.models = new HashMap<String, Model>();
    }

    public void die() {
        this.instances.clear();
        this.assets.dispose();
    }

    public void addModel(String filename) {
        this.assets.load(filename, Model.class);
        this.filenames.add((Object)filename);
        this.loading = true;
    }

    public boolean isDoneLoading() {
        this.loading = false;
        return true;
    }

    public Model getModel(String filename) {
        return (Model)this.assets.get(filename, Model.class);
    }

    public void setModelInstance(String filename, Vector3 position, Vector3 rotation, Vector3 scale) {
        ModelInstance modelInstance = new ModelInstance(this.getModel(filename));
        modelInstance.transform.rotate(rotation, 1.0f).translate(position.x, position.y, position.z).scale(scale.x, scale.y, scale.z);
        this.instances.add((Object)modelInstance);
    }

    public void draw(ModelBatch modelBatch, Environment environment) {
        modelBatch.render(this.instances, environment);
    }

    public ModelInstance getInstance(int index) {
        return (ModelInstance)this.instances.get(index);
    }

    public boolean isAssetsDoneLoading() {
        return this.assets.update();
    }
}

