uniform float iGlobalTime;
uniform vec3 iResolution;


varying vec4 v_shade;

#ifdef VERTEX
uniform float u_glow;
uniform float u_mode;
attribute vec4 a_pos;
uniform mat4 u_proj;

void main(void)
{
	float t;
	vec4 moi;
		t = iGlobalTime;
	if (u_mode < 0.5)
	{
		mat2 rot = mat2(sin(t), cos(t),-cos(t), sin(t));
		moi = a_pos * 2.0;
		//moi.xz = rot * moi.xz;
		if (length(moi.xy) < 0.2)
			moi.xy = normalize(moi.xy) * 0.2;
		moi.z = -0.0-mod(moi.z - iGlobalTime, 4.0);
		gl_Position = u_proj * moi;
		gl_PointSize = max(2.0, 6.0 - gl_Position.z * 1.6);
		v_shade = vec4(0.0, 0.1, 1.0, 0.0) * max(0.0, 0.5 - gl_Position.z * 0.1);
		v_shade += vec4(0.8, 0.2, 0.2, 0.0) * max(0.0, 0.5 - gl_Position.z * 0.2) * u_glow;
	}
	else
	{
		float a = t * 0.45;
		mat2 rot = mat2(sin(a), cos(a),-cos(a), sin(a));
		moi = a_pos;

		moi.xz = rot * moi.xz;
//		moi.z = -1.0+mod(moi.z + iGlobalTime, 1.0);

		float d = length(moi.xyz);
		float dn = clamp(d * 1.0, 1.0, 1.3) + (sin(t+a_pos.y * 7.0 + a_pos.x * 9.0) * 0.2);
//		dn *= 1.0 - (pow(2.718, -t*1.3) * cos(t*4.0));

		moi.xyz = (moi.xyz / d) * dn * 2.0;
		moi.z -= 3.2;

		vec3 ld = normalize(vec3(1.0, 0.0, -0.0));
		v_shade = vec4(0.6, 0.1, 0.5, 0.0) * clamp(dot(moi.xyz, ld), 0.3, 1.0) * 3.0;

//		v_shade = mix(vec4(1.0, 0.3, 0.4, 0.0), vec4(0.1, 0.5, 1.0, 0.0), clamp(dot(moi.xyz, ld), 0.0, 1.0));

		v_shade *= u_glow;


		gl_Position = u_proj * moi;
		v_shade *= max(0.0, 0.5 - gl_Position.z * 0.1);
		//gl_PointSize = max(2.0, 6.0 - gl_Position.z * 1.6);
		gl_PointSize = clamp(-dot(moi.xyz, ld) * 5.0, 2.0 , 5.0);

	}

}
#endif

#ifdef FRAGMENT

uniform sampler2D iChannel0;

void main(void)
{

    gl_FragColor = v_shade;

}
#endif
