#version 120

uniform float iGlobalTime;
uniform vec3 iResolution;
uniform samplerCube iChannel0;
uniform sampler2D iChannel2;
uniform sampler2D iChannel1;

uniform float u_interp;
//uniform vec4 u_mouse;

struct ray_t 
{
	vec3 o;
	vec3 d;
};

vec3 lp = vec3(184.000000, 32.000000, -8.000000);

// entities:  0
vec3 info_player_start = vec3(357.000000, -212.000000, 663.000000);
vec3 lp0 = vec3(104.000000, -128.000000, 432.000000);
vec3 info_player_start2 = vec3(255.000000, -310.000000, 152.000000);
vec4 ball1 = vec4(-130.039059,-460.000000,136.000000,52.000000);
vec4 ball2 = vec4(31.611633,-431.628358,688.000000,81.209644);
vec4 ball3 = vec4(-344.623111,-410.944688,164.943587,101.167411);
uniform vec4 planes[198] = vec4[] (
//  worldspawn
vec4(10.0),
vec4(1.000000, -0.000000, 0.000000, -6032.000000),
vec4(-1.000000, 0.000000, -0.000000, -512.000000),
vec4(0.000000, 0.000000, 1.000000, -0.000000),
vec4(-0.000000, 0.000000, -1.000000, -832.000000),
vec4(0.000000, -1.000000, 0.000000, 512.000000),
vec4(0.000000, 1.000000, 0.000000, -576.000000),
vec4(10.0),
vec4(1.000000, -0.000000, 0.000000, -512.000000),
vec4(-1.000000, -0.000000, -0.000000, -512.000000),
vec4(0.000000, -0.000000, 1.000000, -64.000000),
vec4(0.000000, -0.000000, -1.000000, -0.000000),
vec4(-0.000000, -1.000000, 0.000000, -0.000000),
vec4(0.000000, 1.000000, 0.000000, -576.000000),
vec4(10.0),
vec4(1.000000, -0.000000, 0.000000, -512.000000),
vec4(-1.000000, -0.000000, 0.000000, -512.000000),
vec4(0.000000, -0.000000, 1.000000, 832.000000),
vec4(0.000000, -0.000000, -1.000000, -896.000000),
vec4(0.000000, -1.000000, 0.000000, -0.000000),
vec4(0.000000, 1.000000, 0.000000, -576.000000),
vec4(10.0),
vec4(1.000000, -0.000000, 0.000000, 512.000000),
vec4(-1.000000, -0.000000, -0.000000, -576.000000),
vec4(0.000000, -0.000000, 1.000000, -0.000000),
vec4(0.000000, -0.000000, -1.000000, -832.000000),
vec4(-0.000000, -1.000000, 0.000000, 448.000000),
vec4(0.000000, 1.000000, 0.000000, -576.000000),
vec4(10.0),
vec4(1.000000, -0.000000, 0.000000, -576.000000),
vec4(-1.000000, -0.000000, -0.000000, 512.000000),
vec4(0.000000, -0.000000, 1.000000, 608.000000),
vec4(0.000000, -0.000000, -1.000000, -832.000000),
vec4(-0.000000, -1.000000, 0.000000, -0.000000),
vec4(0.000000, 1.000000, 0.000000, -576.000000),
vec4(10.0),
vec4(1.000000, -0.000000, 0.000000, -512.000000),
vec4(-1.000000, -0.000000, -0.000000, -512.000000),
vec4(0.000000, -0.000000, 1.000000, -0.000000),
vec4(0.000000, -0.000000, -1.000000, -832.000000),
vec4(-0.000000, -1.000000, 0.000000, -0.000000),
vec4(0.000000, 1.000000, 0.000000, -64.000000),
vec4(10.0),
vec4(1.000000, -0.000000, 0.000000, 512.000000),
vec4(-1.000000, -0.000000, -0.000000, -576.000000),
vec4(0.000000, -0.000000, 1.000000, -0.000000),
vec4(0.000000, -0.000000, -1.000000, -832.000000),
vec4(-0.000000, -1.000000, 0.000000, -0.000000),
vec4(0.000000, 1.000000, 0.000000, -192.000000),
vec4(10.0),
vec4(1.000000, -0.000000, 0.000000, 512.000000),
vec4(-1.000000, -0.000000, -0.000000, -576.000000),
vec4(0.000000, -0.000000, 1.000000, 576.000000),
vec4(0.000000, -0.000000, -1.000000, -832.000000),
vec4(-0.000000, -1.000000, 0.000000, 192.000000),
vec4(0.000000, 1.000000, 0.000000, -448.000000),
vec4(10.0),
vec4(1.000000, -0.000000, 0.000000, 512.000000),
vec4(-1.000000, -0.000000, -0.000000, -576.000000),
vec4(0.000000, -0.000000, 1.000000, -0.000000),
vec4(0.000000, -0.000000, -1.000000, -256.000000),
vec4(-0.000000, -1.000000, 0.000000, 192.000000),
vec4(0.000000, 1.000000, 0.000000, -448.000000),
vec4(10.0),
vec4(1.000000, -0.000000, 0.000000, 64.000000),
vec4(-1.000000, -0.000000, -0.000000, -448.000000),
vec4(0.000000, -0.000000, 1.000000, -0.000000),
vec4(0.000000, -0.000000, -1.000000, -192.000000),
vec4(-0.000000, -1.000000, 0.000000, 384.000000),
vec4(0.000000, 1.000000, 0.000000, -416.000000),
vec4(10.0),
vec4(1.000000, -0.000000, 0.000000, 416.000000),
vec4(-1.000000, -0.000000, -0.000000, -448.000000),
vec4(0.000000, -0.000000, 1.000000, -0.000000),
vec4(0.000000, -0.000000, -1.000000, -192.000000),
vec4(-0.000000, -1.000000, 0.000000, 416.000000),
vec4(0.000000, 1.000000, 0.000000, -512.000000),
vec4(10.0),
vec4(1.000000, -0.000000, 0.000000, 64.000000),
vec4(-1.000000, -0.000000, -0.000000, -96.000000),
vec4(0.000000, -0.000000, 1.000000, -0.000000),
vec4(0.000000, -0.000000, -1.000000, -192.000000),
vec4(-0.000000, -1.000000, 0.000000, 416.000000),
vec4(0.000000, 1.000000, 0.000000, -512.000000),
vec4(10.0),
vec4(1.000000, -0.000000, 0.000000, 208.000000),
vec4(-1.000000, -0.000000, -0.000000, -304.000000),
vec4(0.000000, -0.000000, 1.000000, 240.000000),
vec4(0.000000, -0.000000, -1.000000, -368.000000),
vec4(-0.000000, -1.000000, 0.000000, 416.000000),
vec4(0.000000, 1.000000, 0.000000, -448.000000),
vec4(10.0),
vec4(1.000000, -0.000000, 0.000000, 208.000000),
vec4(-1.000000, -0.000000, -0.000000, -304.000000),
vec4(0.000000, -0.000000, 1.000000, 336.000000),
vec4(0.000000, -0.000000, -1.000000, -368.000000),
vec4(-0.000000, -1.000000, 0.000000, 320.000000),
vec4(0.000000, 1.000000, 0.000000, -416.000000),
vec4(10.0),
vec4(1.000000, -0.000000, 0.000000, -576.000000),
vec4(-1.000000, -0.000000, -0.000000, 512.000000),
vec4(0.000000, -0.000000, 1.000000, -0.000000),
vec4(0.000000, -0.000000, -1.000000, -224.000000),
vec4(-0.000000, -1.000000, 0.000000, -0.000000),
vec4(0.000000, 1.000000, 0.000000, -576.000000),
vec4(10.0),
vec4(1.000000, -0.000000, 0.000000, -6340.000000),
vec4(-1.000000, 0.000000, -0.000000, 576.000000),
vec4(-0.000000, -0.000000, 1.000000, 160.000000),
vec4(0.000000, -0.000000, -1.000000, -224.000000),
vec4(0.000000, -1.000000, 0.000000, -0.000000),
vec4(0.000000, 1.000000, 0.000000, -576.000000),
vec4(10.0),
vec4(1.000000, -0.000000, 0.000000, -6008.000000),
vec4(-1.000000, 0.000000, -0.000000, 576.000000),
vec4(-0.000000, -0.000000, 1.000000, 608.000000),
vec4(0.000000, -0.000000, -1.000000, -672.000000),
vec4(0.000000, -1.000000, 0.000000, -0.000000),
vec4(0.000000, 1.000000, 0.000000, -576.000000),
vec4(10.0),
vec4(1.000000, -0.000000, 0.000000, -6080.000000),
vec4(-1.000000, 0.000000, -0.000000, 512.000000),
vec4(0.000000, 0.000000, 1.000000, 224.000000),
vec4(-0.000000, 0.000000, -1.000000, -608.000000),
vec4(0.000000, -1.000000, 0.000000, -0.000000),
vec4(0.000000, 1.000000, 0.000000, -160.000000),
vec4(10.0),
vec4(1.000000, -0.000000, 0.000000, -480.000000),
vec4(-1.000000, -0.000000, 0.000000, 352.000000),
vec4(0.000000, -0.000000, 1.000000, 672.000000),
vec4(0.000000, -0.000000, -1.000000, -800.000000),
vec4(0.000000, -1.000000, 0.000000, 416.000000),
vec4(0.000000, 1.000000, 0.000000, -512.000000),
vec4(10.0),
vec4(0.965716, -0.000000, -0.259601, -640.955019),
vec4(-0.477712, -0.290855, 0.828972, 929.847301),
vec4(-0.259601, -0.000000, -0.965716, -650.923700),
vec4(0.000000, 1.000000, 0.000000, -416.000000),
vec4(10.0),
vec4(1.000000, 0.000000, 0.000000, 72.000000),
vec4(-1.000000, -0.000000, 0.000000, -144.000000),
vec4(0.000000, -0.000000, 1.000000, 376.000000),
vec4(0.000000, -0.000000, -1.000000, -504.000000),
vec4(-0.000000, -1.000000, 0.000000, 64.000000),
vec4(0.000000, 1.000000, 0.000000, -80.000000),
vec4(10.0),
vec4(1.000000, -0.000000, 0.000000, 192.000000),
vec4(-1.000000, -0.000000, -0.000000, -320.000000),
vec4(0.000000, -0.000000, 1.000000, 8.000000),
vec4(0.000000, -0.000000, -1.000000, -120.000000),
vec4(-0.000000, -1.000000, 0.000000, 352.000000),
vec4(0.000000, 1.000000, 0.000000, -384.000000),
vec4(10.0),
vec4(1.000000, -0.000000, 0.000000, 199.013551),
vec4(-1.000000, -0.000000, 0.000000, -311.774339),
vec4(-0.000000, -0.978595, 0.205793, 283.020489),
vec4(0.000000, -0.000000, 1.000000, 14.390486),
vec4(0.000000, -0.000000, -1.000000, -110.390486),
vec4(0.000000, 1.000000, 0.000000, -352.000000),
vec4(10.0),
vec4(1.000000, -0.000000, 0.000000, 192.000000),
vec4(-1.000000, -0.000000, -0.000000, -320.000000),
vec4(0.000000, -0.000000, 1.000000, 128.000000),
vec4(0.000000, -0.000000, -1.000000, -176.000000),
vec4(-0.000000, -1.000000, 0.000000, 383.000000),
vec4(0.000000, 1.000000, 0.000000, -384.000000),
vec4(10.0),
vec4(1.000000, -0.000000, 0.000000, 272.000000),
vec4(-1.000000, -0.000000, 0.000000, -299.180535),
vec4(0.000000, -0.000000, 1.000000, 336.000000),
vec4(0.000000, -0.000000, -1.000000, -365.586814),
vec4(-0.000000, -1.000000, 0.000000, 448.000000),
vec4(0.000000, 1.000000, 0.000000, -512.000000),
vec4(10.0),
vec4(1.000000, 0.000000, 0.000000, 213.159516),
vec4(-1.000000, -0.000000, 0.000000, -240.000000),
vec4(-0.000000, -0.000000, 1.000000, 336.000000),
vec4(0.000000, -0.000000, -1.000000, -364.419814),
vec4(0.000000, -1.000000, 0.000000, 448.000000),
vec4(0.000000, 1.000000, 0.000000, -512.000000),
vec4(10.0),
vec4(1.000000, -0.000000, 0.000000, 272.000000),
vec4(-1.000000, -0.000000, 0.000000, -299.537448),
vec4(0.000000, 0.000000, 1.000000, 244.868129),
vec4(0.000000, -0.000000, -1.000000, -272.000000),
vec4(0.000000, -1.000000, 0.000000, 448.000000),
vec4(0.000000, 1.000000, 0.000000, -512.000000),
vec4(10.0),
vec4(1.000000, -0.000000, 0.000000, 211.080555),
vec4(-1.000000, -0.000000, 0.000000, -240.000000),
vec4(-0.000000, -0.000000, 1.000000, 243.946550),
vec4(0.000000, -0.000000, -1.000000, -272.000000),
vec4(0.000000, -1.000000, -0.000000, 448.000000),
vec4(0.000000, 1.000000, 0.000000, -512.000000),
vec4(10.0),
vec4(0.0),
vec4(0.0),
vec4(0.0)
);
uniform int materials[198] = int[] (
-1, 
1, 
1, 
1, 
1, 
1, 
1, 
-1, 
2, 
2, 
2, 
2, 
2, 
2, 
-1, 
2, 
2, 
2, 
2, 
2, 
2, 
-1, 
2, 
2, 
2, 
2, 
2, 
2, 
-1, 
2, 
2, 
2, 
2, 
2, 
2, 
-1, 
3, 
3, 
3, 
3, 
3, 
3, 
-1, 
2, 
2, 
2, 
2, 
2, 
2, 
-1, 
2, 
2, 
2, 
2, 
2, 
2, 
-1, 
2, 
2, 
2, 
2, 
2, 
2, 
-1, 
4, 
4, 
4, 
4, 
4, 
4, 
-1, 
4, 
4, 
4, 
4, 
4, 
4, 
-1, 
4, 
4, 
4, 
4, 
4, 
4, 
-1, 
5, 
5, 
5, 
5, 
5, 
5, 
-1, 
5, 
5, 
5, 
5, 
5, 
5, 
-1, 
2, 
2, 
2, 
2, 
2, 
2, 
-1, 
2, 
2, 
2, 
2, 
2, 
2, 
-1, 
2, 
2, 
2, 
2, 
2, 
2, 
-1, 
2, 
2, 
2, 
2, 
2, 
2, 
-1, 
6, 
6, 
6, 
6, 
6, 
6, 
-1, 
7, 
7, 
7, 
7, 
-1, 
8, 
8, 
8, 
8, 
8, 
8, 
-1, 
9, 
9, 
9, 
9, 
9, 
4, 
-1, 
9, 
9, 
9, 
9, 
10, 
9, 
-1, 
9, 
9, 
9, 
9, 
9, 
9, 
-1, 
5, 
5, 
5, 
5, 
5, 
5, 
-1, 
5, 
5, 
5, 
5, 
5, 
5, 
-1, 
5, 
5, 
5, 
5, 
5, 
5, 
-1, 
5, 
5, 
5, 
5, 
5, 
5, 
0,
100,
101,
102);



void doplane(in ray_t ray, in vec4 plane, in int plane_id, inout float loc_min, inout float loc_max, inout int loc_plane_id) {
	float det=dot(plane.xyz,ray.d); 
	if (abs(det) > 0.0000001) {
	float num=plane.w - dot(plane.xyz, ray.o); float curdist=num/det;
	if (det > 0.0 && curdist > loc_min) { loc_min = curdist; loc_plane_id=plane_id; }
	if (det < 0.0 && curdist < loc_max) { loc_max = curdist; }
}
}

void dosphere(in ray_t ray, in vec4 sphere, in int plane_id, inout float loc_min, inout float loc_max, inout int loc_plane_id)
{
	vec3 d1 = ray.o - sphere.xyz;
	float b = 2.0 * dot(ray.d, d1);
	float c = dot(d1,d1) - sphere.w*sphere.w;

	float delta = b*b - 4.0*c;

	if (delta >= 0.0)
	{
		loc_min = (-b-sqrt(delta))/ (2.0);
		loc_max= (-b+sqrt(delta))/ (2.0);

		loc_plane_id = plane_id;
	}
	else
	{
		loc_min = 100000.0;
		loc_max = -100000.0;
	}
}


float trage(inout ray_t ray, out int plane_id) {
int loc_plane_id;
plane_id = 0;
float dist = 1000000.0;
float det, num, curdist;

float loc_min = -1000000.0;
float loc_max = 1000000.0;

for (int i = 1; i < 195; i++) { 
if (planes[i].x > 9.0) { 
  if (loc_min < loc_max && loc_min > 0.0 && loc_min < dist) { dist = loc_min; plane_id = loc_plane_id; }
  loc_min = -1000000.0; loc_max = 1000000.0;  }
else { doplane(ray, planes[i], i, loc_min, loc_max, loc_plane_id); }
}

dosphere(ray, ball1, 195, loc_min, loc_max, loc_plane_id);
if (loc_min < dist && loc_min > 0.0) { dist = loc_min; plane_id = loc_plane_id; }
dosphere(ray, ball2, 196, loc_min, loc_max, loc_plane_id);
if (loc_min < dist && loc_min > 0.0) { dist = loc_min; plane_id = loc_plane_id; }
dosphere(ray, ball3, 197, loc_min, loc_max, loc_plane_id);
if (loc_min < dist && loc_min > 0.0) { dist = loc_min; plane_id = loc_plane_id; }
return dist; }

// LOL

float shade(inout ray_t ray, in float dist, in int plane_id, inout vec3 outcol, inout vec3 refblendfac)
{
	if (plane_id == 0)
	{
		outcol += textureCube(iChannel0, ray.d.xzy).xyz * refblendfac;
		return 0.0;
	}

	vec3 hp = ray.o + ray.d * dist;
	int mat = materials[plane_id];
	vec3 normal;
	vec3 color;
	vec3 thiscol = vec3(0.0);

	normal = -planes[plane_id].xyz;

	float reflection_amount = 0.8;
	float specular_amount = 1.0;

	if (mat == 1)
	{
		color = vec3(0.1) + vec3(0.6) * mod(floor(hp.x * 0.01) + floor(hp.z * 0.01), 2.0);
		reflection_amount = 0.9;

	}
	else if (mat == 2)
		color = vec3(0.3, 0.4, 0.1);
	else if (mat == 3)
		color = vec3(0.1, 0.1, 0.5);
	else if (mat == 4)
	{
		color = vec3(0.8, 0.5, 0.1);
		reflection_amount = 0.1;
		specular_amount = 0.0;
	}
	else if (mat == 5)
	{
		color = vec3(0.9, 0.6, 0.1);
		reflection_amount = 0.1;
		specular_amount = 0.0;
	}
	else if (mat == 6)
	{
		color = vec3(0.8, 0.3, 0.1);
		reflection_amount = 1.0;
	}
	else if (mat == 7)
	{
		color = vec3(0.2, 0.8, 0.2);
		reflection_amount = 1.0;
	}
	else if (mat == 8)
	{
		thiscol = vec3(1.0);
		color = vec3(1.0);
	}
	else if (mat == 9)
		color = vec3(0.5, 0.5, 0.5);
	else if (mat == 10)
	{
	//	vec2 uv = fract(vec2(-hp.x, hp.y) * u_mouse.zw + u_mouse.xy);
		vec2 uv = fract(vec2(-hp.x, hp.y) * vec2(0.008906, 0.011208) + vec2(0.770312, 0.962500));

		float frame = mod(-floor(iGlobalTime * 25.0), 660.0);
		vec2 frame2 = vec2(mod(frame, 22.0), floor(frame/22.0));
		uv = (uv + frame2) / vec2(22.0, 30.0);

		color = texture2D(iChannel1, uv).rgb;

		reflection_amount = 0.1;
	}
	else if (mat == 100)
	{
		normal = normalize(hp - ball1.xyz);
		color = vec3(0.8, 0.1, 1.0);
	}
	else if (mat == 101)
	{
		normal = normalize(hp - ball2.xyz);
		color = vec3(0.6, 0.1, 1.0);
	}
	else if (mat == 102)
	{
		normal = normalize(hp - ball3.xyz);
		color = vec3(0.75, 0.4, 1.0);
	}
	else
		color = vec3(0.2);

/*
	textures['afloor3_1'] = 1;
	textures['city2_3'] = 2;
	textures['ceiling1_3'] = 3;
	textures['wizwood1_3'] = 4;
	textures['wizwood1_2'] = 5;
	textures['*lava1'] = 6;
	textures['ground1_1'] = 7;
	textures['light3_8'] = 8;
	textures['comp1_7'] = 9;
	textures['+3butnn'] = 10;
*/


	vec3 lightvec = lp - hp;
	float lightdist = length(lightvec);
	vec3 ld = lightvec / lightdist;

	float diffuse = clamp(dot(normal, ld), 0.0, 1.0);

	ray_t shadowray;
	shadowray.o = hp + ld * 0.01;
	shadowray.d = ld;

	int id_unused;
	if (trage(shadowray, id_unused) < lightdist)
	{
		diffuse = 0.0;
		specular_amount = 0.0;
	}

	diffuse += 0.1;

//	outcol = vec4(normal * 0.5 + vec3(0.5), 1.0);
	
	vec3 ref_ray_d = ray.d - 2.0*dot(ray.d, normal) * normal;
	float ref_fac = pow(clamp(-dot(normal, ray.d), 0.0, 1.0), 2.0);
	//float ref_fac = 1.0;
    vec3 new_refblendfac = ref_fac * refblendfac * reflection_amount;
		
//	ref_ray_d = -ref_ray_d;
		
//	ref_col = textureCube(iChannel0, ref_ray_d) * 1.0 * ref_fac;

		
	specular_amount *= ref_fac;
	float spec_light = pow(clamp(dot(ld, ref_ray_d), 0.0, 1.0), 50.0);


	
	// diffuse lighting
//    	diffuse = 0.2;
	thiscol += color * diffuse;
	// specular hilight
	thiscol += spec_light * specular_amount;
	// SMG lighting
	thiscol += vec3(pow(1.0 - ref_fac, 10.0) * 0.3);

	float atten = max(0.0, 1.0 - dist * 0.0006);
	new_refblendfac *= atten;
	thiscol *= atten;
	
	// mix with previous stage and set up next
	outcol += thiscol * refblendfac;
	ray.d = ref_ray_d;
	ray.o = hp;
	refblendfac = new_refblendfac;

//	outcol = color;
//	refblendfac = vec4(0.0);
//	return 0.0;

	return length(refblendfac);
}

void trace(in ray_t ray, out vec3 outcol)
{
	vec3 hp;
	vec3 normal;
	vec3 color;
	int mat;

	float cont;

	ray_t refray;
	vec3 refblendfac;

	outcol = vec3(0.0);
	refray = ray;
	refblendfac = vec3(1.0);
	float dist;

	dist = trage(refray, mat);
	cont = shade(refray, dist, mat, outcol, refblendfac);

	vec3 fuggol = vec3(0.0);

	if (cont > 0.05)
	{
		dist = trage(refray, mat);
		cont = shade(refray, dist, mat, outcol, refblendfac);

		fuggol = vec3(0.0, 0.0, 1.0);
	}

	if (cont > 0.05)
	{
		dist = trage(refray, mat);
		cont = shade(refray, dist, mat, outcol, refblendfac);

		fuggol = vec3(0.0, 1.0, 1.0);
	}

	if (cont > 0.05)
	{
		dist = trage(refray, mat);
		cont = shade(refray, dist, mat, outcol, refblendfac);

		fuggol = vec3(1.0, 0.0, 0.0);
	}
//	return;

	if (cont > 0.05)
	{
		dist = trage(refray, mat);
		cont = shade(refray, dist, mat, outcol, refblendfac);

		fuggol = vec3(1.0, 1.0, 0.0);
	}

	if (cont > 0.05)
	{
		dist = trage(refray, mat);
		cont = shade(refray, dist, mat, outcol, refblendfac);

		fuggol = vec3(1.0, 1.0, 1.0);
	}
#if 0
	vec3 ld = normalize(lp - ray.o);
	float spec_light = pow(clamp(dot(ld, ray.d), 0.0, 1.0), 50.0);
	outcol += vec3(1.0) * spec_light;
#endif


//	outcol = fuggol;

}



void rX(inout vec3 p, float a)
	{
        float c,s;
		vec3 q=p;
        c = cos(a); s = sin(a);
        p.y = c * q.y - s * q.z;
        p.z = s * q.y + c * q.z;
	}

void rY(inout vec3 p, float a)
	{
        float c,s;
		vec3 q=p;
        c = cos(a); s = sin(a);
        p.x = c * q.x + s * q.z;
        p.z = -s * q.x + c * q.z;
	}

void rZ(inout vec3 p, float a)
	{
        float c,s;
		vec3 q=p;
        c = cos(a); s = sin(a);
        p.x = c * q.x - s * q.y;
        p.y = s * q.x + c * q.y;
	}


void main(void)
{
	vec2 uv = gl_FragCoord.xy / iResolution.xy;
	
	uv.xy -= vec2(0.5);
	uv.x *= iResolution.z;
//    uv.xy *= 0.1;
//    uv.xy -= (iMouse.xy / iResolution.xy) - vec2(0.5);
	vec2 p = uv.xy * 2.0;
	uv.xy += vec2(0.5);

	ray_t ray;
//	ray.d = vec3(uv.x - 0.5, 1.0, uv.y - 0.5);

	ray.d = 1. * vec3(-1.0, p.y, p.x) / (3. * 512.);

//	rY(ray.d, iGlobalTime);


	float yang = 3.14159 * mix(-0.5, -0.2, u_interp);
	rY(ray.d, yang);

	rZ(ray.d, sin(iGlobalTime * 0.4) * 0.1 * u_interp);

	ray.d = normalize(ray.d);

//	rotate(ray.o, ray.d);

	ray.o = mix(info_player_start2, info_player_start, u_interp);


	// POS OFFSET + vec3(1.5, 3.0, -28.0);


	//ray.o.x = -160.0 + sin(iGlobalTime * 0.2) * 260.0;

	//ray.o += sin(vec3(iGlobalTime) * ivec3(1.51123,1.0,1.21123)) * vec3(10.0, 10.0, 10.0);

	lp = lp0 + sin(vec3(iGlobalTime) * ivec3(2.6231,2.5621,2.4123)) * vec3(10.0, 10.0, 10.0);

  //  ro += rd * ((0.5)/rd.z);
	
//	ray.o = rotinv * ray.o;
//	ray.d = rotinv * ray.d;
	
	
	vec3 outcol;
	trace(ray, outcol);

	gl_FragColor = vec4(outcol, 1.0);

//	gl_FragColor = 1.0-vec4(d * 0.2);
//	vec4 vignet = vec4(pow(length(uv - vec2(0.5)), 5.0)) * vec4(1.0);
//	vignet = vignet + texture2D(iChannel2, uv * 2.0) * 18.4 * (0.02 + vignet);
//	vignet *= vec4(0.3, 0.6, 1.0, 1.0);
//	gl_FragColor = clamp(outcol * vec4(1.0) * 2.0, vec4(0.0), vec4(1.0)) - vignet;
	//gl_FragColor = vec4(1.0) - vignet;
}