function Section( id , page , params ){

  this.page = page;
  this.id = id;

  this.prevSection = undefined;
  this.nextSection = undefined;

  this.active  = false;
  this.current = false; 

  this.params = _.defaults(params || {} , {

    offset: G.pageTurnerOffset,
    transitionTime: 9000,//"endOfLoop",
    textDeathTime: 7000,

    cameraPosition:   G.position.relative,
    lookPosition:     new THREE.Vector3(),

    transitionIn:     function(){},
    start:            function(){},
    transitionOut:    function(){},
    end:              function(){},
    transitioningOut: function(){},
    transitioningIn:  function(){},
    currentUpdate:    function(){},
    activeUpdate:     function(){},
    
  });


  //bubblin up dem params
  for( var propt in this.params ){
    this[propt] = this.params[propt];
  }

  if( this.textChunk ){
    this.text = new PhysicsText( this.textChunk );
  }


  this.frame = new Frame( this );


}



Section.prototype._transitionIn = function(){

  if( !this.prevSection ){
    this.active = true;
    //this.frame.add();
    this._start();
  }else{
    //this.frame.add();
    this.active = true;
    this.transitionIn();
  }

  if( this.frame.fish ){
    this.frame.fish.activate( this.page.scene );
  }

}

Section.prototype._start = function(){
 
  this.start();

  if( this.text ){
    console.log('ACTIVATINGS');
    this.text.activate();
  }

  this.current = true;

  if( this.nextSection ){ 

     

    var callback = this.nextSection.createTransitionInCallback();

    window.setTimeout( function(){

      var callback = this.nextSection.createTransitionInCallback();

      callback();

    }.bind( this ), 3000 );

    var mesh  = this.page.createTurnerMesh( this.offset , callback );
    //this.page.scene.add( mesh );

  }else{


     window.setTimeout( function(){

       
       var newPos = new THREE.Vector3( 0 , 0 , 10000 );
       newPos.add( this.page.position );

       console.log( newPos );

      var tween = new G.tween.Tween( G.camera.position ).to( newPos , 10000 );

      tween.onUpdate( function( t ){

        G.audio.mute.gain.value = 1. - t;
        
        document.getElementById('curtain').style.opacity = t;
      }.bind( this ));



      tween.start();

     }.bind( this ), 8000 );

      //this.page.endMesh.add( this.page );

  }

}

Section.prototype._transitionOut = function(){
  
  if( this.text ){
    this.text.kill( this.textDeathTime );
  }
  this.current = false;
  this.transitionOut();

}


Section.prototype._transitioningOut = function(t){
  
  this.frame.uniforms.opacity.value = 1-t;
  this.transitioningOut();

}

Section.prototype._transitioningIn = function(t){
  
  this.frame.uniforms.opacity.value = t;
  this.transitioningIn();

}


Section.prototype._end = function(){

  this.active = false;
  this.end();

}


Section.prototype.createTransitionInCallback = function(){

  var callback = function(){
   
    this.prevSection._transitionOut();
    this._transitionIn();

    var transitionTime = this.params.transitionTime;

    if(  transitionTime == "endOfLoop" ){
      
      var percentTilEnd = 1 - this.page.looper.percentOfMeasure;
      
      // Making sure the transition is never toooooo quick
      if( percentTilEnd < .3 ){
        percentTilEnd += 1;
      }
      var timeTilEnd = percentTilEnd * this.page.looper.measureLength;

      transitionTime = (timeTilEnd-.01) * 1000;

    }

    //var lookAt = this.lookPosition || this.page.position;
    this.page.tweenCamera( this.cameraPosition , transitionTime ,  function(){

      this.prevSection._end();
      this._start();
        
    }.bind( this ),
    this.lookPosition,
    function( t ){
      
      this._transitioningIn( t );
      this.prevSection._transitioningOut( t );
      
    }.bind( this ));
    
  }.bind( this );

  return callback;



}

Section.prototype._update = function(){

  if( this.text ){
    this.text.update();
  }
  
  if( this.active ){
    this.activeUpdate();
    this.frame.update();

    var v = this.params.iPointFunction();
    G.IMARK.position.copy( v );
    //console.log( v );
    G.v1.copy( v ); 
    G.iPoint.copy( G.v1 );
    G.iPoint.relative.copy( G.iPoint );
    G.iPoint.relative.sub( G.position );

    //console.log( G.iPoint.relative );
    G.iTextPoint.copy( G.v1 )
    G.iTextPoint.relative.copy( G.iTextPoint );
    G.iTextPoint.relative.sub( G.position );

  }

  if( this.current ){
    this.currentUpdate();
  }

}




