#include "fw_Globals.fxi"		// shared stuff
#include "fw_States.fxi"		// standard fw_Effect states

float gImageAspect;


//-----------------------------------------------------------------------------
// Textures
//-----------------------------------------------------------------------------

Texture2D gHeightTexture;
Texture2D gHeightTexture2;

Texture2D gTexture1;

Texture2D gVerticalInnerEdge;
Texture2D gVerticalOuterEdge;
Texture2D gHorisontalInnerEdge;
Texture2D gHorisontalOuterEdge;


SamplerState sampler1
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = WRAP;
    AddressV = WRAP;
};


//----------------------------------------------------------------------------
// Vertex input stream.
//----------------------------------------------------------------------------
struct VS_INPUT
{
    float3 position : POSITION0;
    uint vertexId : SV_VertexId;
};

struct VS_OUTPUT
{
    float4 position : SV_POSITION;
    float4 depth_falloff_colorScale_fadeOutEdges : TEXCOORD4;
    float3 positionWorldSpace : TEXCOORD0;
    float2 uv : TEXCOORD1;
    float4 edgeUvs : TEXCOORD2;
    float4 edge : TEXCOORD3;
};


//-----------------------------------------------------------------------------
// Shaders
//-----------------------------------------------------------------------------

int gNumRows;
int gNumColumns;

float gScrollValue;

float gHeightFade = 1.0;

float ReadHeight(int x, int y)
{
    float h1 = gHeightTexture.Load(int3(x-40, y, 0)).r;
    float h2 = gHeightTexture2.Load(int3(x-40, y, 0)).r;
    return (1.0 - gHeightFade)*h1 + gHeightFade*h2;
}


VS_OUTPUT
VS(VS_INPUT In)
{
    VS_OUTPUT Out;

    // Compute the grid cell index.
    int x = (In.vertexId/8) % gNumColumns;
    int y = gNumRows - (In.vertexId/8) / gNumColumns;
//    int y = (In.vertexId/8) / gNumColumns;
    bool top = (In.vertexId % 8) >= 4;

    // Scroll.
    x += (int) floor(gScrollValue);
    float offset = (gScrollValue % 1.0)/(0.5*gNumColumns);

    // Read depth from the heightmap texture.
    float height = top ?
        ReadHeight(x, y) :
        0.0;


    Out.edge = float4(0.0, 0.0, 0.0, 0.0);
    int i = (In.vertexId % 8);

    float r = ReadHeight(x+1, y);
    float l = ReadHeight(x-1, y);
    float u = ReadHeight(x, y-1);
    float d = ReadHeight(x, y+1);

    if (i == 4 || i == 5)
    {
        // bottom
        Out.edge.z = 0.0;
        Out.edge.w = 0.0;
        if (d > height)
            Out.edge.w = 1.0;
        else if (d < height)
            Out.edge.w = -1.0;
    }
    else
    {
        // top
        Out.edge.z = 0.0;
        Out.edge.w = 0.0;
        if (u > height)
            Out.edge.z = 1.0;
        else if (u < height)
            Out.edge.z = -1.0;
    }

    if (i == 4 || i == 6)
    {
        // left
        Out.edge.x = 0.0;
        Out.edge.y = 0.0;
        if (l > height)
            Out.edge.x = 1.0;
        else if (l < height)
            Out.edge.x = -1.0;
    }
    else
    {
        // right
        Out.edge.x = 0.0;
        Out.edge.y = 0.0;
        if (r > height)
            Out.edge.y = 1.0;
        else if (r < height)
            Out.edge.y = -1.0;
    }

    // Compute the world space coordinates.
    float3 positionWorldSpace =
        /* world postion */ float3(380.0f*float2(In.position.x - offset, In.position.y), -300.0 + 145.0f*height);
    positionWorldSpace.x *= (2*16.0/9.0);

    Out.positionWorldSpace = positionWorldSpace.xyz;
    Out.position = mul(float4(positionWorldSpace, 1.0), ViewProjection);

    float occlusion = saturate(r-height) + saturate(l-height) + saturate(d-height) + saturate(u-height);
//    Out.color *= pow(1.0 - 0.25*occlusion, 8.0);
    Out.depth_falloff_colorScale_fadeOutEdges = float4(
        height, 
        top ? 1.0 : 0.0, 
        0.8*(0.1 + 0.8*pow(height, 1.2)),
        occlusion);

//    Out.normalWorldSpace = mul(In.normal, (float3x3)World);
//    Out.positionObjectSpace = In.position.xyz;
//    Out.positionLightSpace = mul(pos, gLightViewProjection);

    Out.uv.xy = 0.5 + 0.5*float2(In.position.x, -In.position.y);
    Out.uv.x += floor(gScrollValue)/gNumColumns;

    const int egdeTextureNumColumns = 1;
    Out.edgeUvs.xy = 0.5 + 0.5*float2(In.position.x, -In.position.y);
    Out.edgeUvs.x *= (gNumColumns+1)/(float)egdeTextureNumColumns;
    Out.edgeUvs.x += floor(gScrollValue)/(float)egdeTextureNumColumns;

    const int egdeTextureNumRows = 1;
    Out.edgeUvs.zw = 0.5 + 0.5*float2(In.position.x, -In.position.y);
    Out.edgeUvs.w *= (gNumRows+1)/(float)egdeTextureNumRows;

    return Out;
}

Texture2D gHorInnerTexture;
Texture2D gHorOuterTexture;
Texture2D gVertInnerTexture;
Texture2D gVertOuterTexture;

float3 gHeroPosition;

float4 
PS(VS_OUTPUT In) : SV_TARGET0
{
    float4 vInnerEdge = gVertInnerTexture.Sample(sampler1, In.edgeUvs.xy);
    vInnerEdge.rgb *= vInnerEdge.a;

    float4 vOuterEdge = gVertOuterTexture.Sample(sampler1, In.edgeUvs.xy);
    vOuterEdge.rgb *= 0.35*vOuterEdge.a;

    float4 hInnerEdge = gHorInnerTexture.Sample(sampler1, In.edgeUvs.zw);
    hInnerEdge.rgb *= hInnerEdge.a;

    float4 hOuterEdge = gHorOuterTexture.Sample(sampler1, In.edgeUvs.zw);
    hOuterEdge.rgb *= 0.35*hOuterEdge.a;

    const float kkk = 0.4;
    float verticalEdgeScale = (1.0 - kkk*abs(In.edge.z))*(1.0 - kkk*abs(In.edge.w));
    verticalEdgeScale *= verticalEdgeScale;

    float4 l = In.edge.x > 0.0 ? vInnerEdge : -vOuterEdge;
    l *= verticalEdgeScale*In.edge.x;

    float4 r = In.edge.y > 0.0 ? vInnerEdge : -vOuterEdge;
    r *= verticalEdgeScale*In.edge.y;

    float horisontalEdgeScale = (1.0 - kkk*abs(In.edge.x))*(1.0 - kkk*abs(In.edge.y));
    horisontalEdgeScale *= horisontalEdgeScale;

    float4 u = In.edge.z > 0.0 ? hInnerEdge : -hOuterEdge;
    u *= horisontalEdgeScale*In.edge.z;

    float4 d = In.edge.w > 0.0 ? hInnerEdge : -hOuterEdge;
    d *= horisontalEdgeScale*In.edge.w;

    float4 edgeColor = l + r + u + d;
    edgeColor.a *= 0.8;
    edgeColor.a *= saturate(3.0*In.depth_falloff_colorScale_fadeOutEdges.w);

    float3 color = gTexture1.Sample(sampler1, In.uv).rgb;

    //    float3 color = pow(gTexture1.Sample(sampler1, In.uv).rgb, float3(2.3, 12.8, 21.3));

//    float t = (abs(ddx(In.depth_falloff_colorScale_fadeOutEdges.x)) < 0.1*RenderDim.z) ?
//        edgeColor.a :
//        pow(In.depth_falloff_colorScale_fadeOutEdges.y, 64.0);
    float t = edgeColor.a;

    // Light from hero particle.
    float3 positionToHero = 
        gHeroPosition - In.positionWorldSpace;
    positionToHero.x *= 0.5;
    float ll = 0.02*0.02*dot(positionToHero, positionToHero);
    float light = 1.0 / (1.0 + ll);

    return float4(
        (1.0 + light*float3(1.0, 0.96, 0.9))*
        In.depth_falloff_colorScale_fadeOutEdges.z*lerp(color, edgeColor.rgb, t), 1.0);
}


technique10 bg
{
    pass P0
    {
        SetBlendState(Blending_None, /*Blendfactor*/ float4(0.0, 0.0, 0.0, 0.0), /*Sample mask*/ 0xFFFFFFFF);
//        SetBlendState(Blending_Alpha, /*Blendfactor*/ float4(0.0, 0.0, 0.0, 0.0), /*Sample mask*/ 0xFFFFFFFF);
        SetDepthStencilState(Depth_Enable, /*ref value*/ 0);
        SetRasterizerState(Culling_None);

        SetVertexShader(CompileShader(vs_4_0, VS()));
        SetGeometryShader(NULL);
        SetPixelShader(CompileShader(ps_4_0, PS()));
    }
}

