#include "fw_Globals.fxi"		// shared stuff
#include "fw_States.fxi"		// standard fw_Effect states


struct VS_INPUT
{
    float4 position : POSITION0;
    float3 normal : NORMAL;
    float2 uv : TEXCOORD0;
};

struct VS_OUTPUT
{
    float4 position : SV_POSITION;
    float3 positionWorldSpace : TEXCOORD0;
    float3 normalWorldSpace : TEXCOORD3;
};


struct PS_OUTPUT
{
    float4 color : SV_TARGET0;
};


matrix gWorldMatrix;

float gDistortionScale = 0.0;
float gDistortionDrift = 0.0;

//--------------------------------------------------------------------------------------
// Vertex Shaders
//--------------------------------------------------------------------------------------
float gWireMeshGlitch;
float4 wireframeVS(
    float4 position : POSITION0, out float cutOffParameter : TEXCOORD0) : SV_POSITION
{
    float4 pos = mul(float4(
        1.19*position.xyz, 1.0), gWorldMatrix);
    float4 pq = mul(pos, ViewProjection);

    cutOffParameter = position.y/400.0f;

    float X = gNoiseTexture.SampleLevel(
        sampLinear, 
        float3(gWireMeshGlitch*2.3883339333f%1.0f, 
            gWireMeshGlitch*1.7717735777f%1.0f, 
            0.01f*pos.y % 1.0f),
        0.0f).r;
//    X = pow(1.06f*X, 9) > 0.8 ? 0.02 : 0.0;
    pq.x -= 110.0f*pow(1.16f*X, 19);

    return pq;
}



VS_OUTPUT DistortedVS(VS_INPUT In)
{
    VS_OUTPUT Out;

    Out.positionWorldSpace =
        mul(float4(In.position.xyz, 1.0), gWorldMatrix);

    Out.normalWorldSpace = 
        mul(In.normal, (float3x3)gWorldMatrix);

    // Displace.
    float X = gNoiseTexture.SampleLevel(
        sampLinear, 
        float3((In.normal.x*2.3883339333f)%1.0f, 
            (In.normal.y*1.7717735777f)%1.0f, 
            (Time + 0.01f*In.normal.y) % 1.0f),
        0.0f).r;

    Out.positionWorldSpace += 50.0*max(0, gDistortionScale - X)*Out.normalWorldSpace.xyz;

    float g = (gDistortionDrift - 1.5*X);
    if (g > 0.0)
    {
        Out.positionWorldSpace.x -= pow(2.0*g, 4.0);
    }

    Out.position = mul(float4(Out.positionWorldSpace, 1.0), ViewProjection);

    return Out;
}


VS_OUTPUT VS(VS_INPUT In)
{
    VS_OUTPUT Out;

    float4 pos = mul(float4(In.position.xyz, 1.0), gWorldMatrix);
    Out.normalWorldSpace = mul(In.normal, (float3x3)gWorldMatrix);

    float3 axis = normalize(float3(1.0, 1.0, 1.0));

    Out.positionWorldSpace = pos.xyz;
    Out.position = mul(pos, ViewProjection);

    return Out;
}

//--------------------------------------------------------------------------------------
// Pixel Shaders
//--------------------------------------------------------------------------------------

float gWireMeshShowPercent;

float4 wireframePS(
    float4 position : SV_POSITION, float cutOffParameter : TEXCOORD0) : SV_TARGET0
{
    if (cutOffParameter > gWireMeshShowPercent)
        discard;

    // Bent.
    float3 color = float3(0.56, 0.24, 0.71);

    return float4(color, 1.0);
}

float gMeshShading;
float3 gLightDirection;

float4 PS(VS_OUTPUT In) : SV_TARGET0
{
    float3 normal = normalize(In.normalWorldSpace);
    float ln = saturate(dot(normal, gLightDirection));
    float3 color = Ambient + ln*Diffuse;

    float luma = dot(float3(0.3, 0.59, 0.11), color);

    float3 color2 = (luma >= 0.4 ? 1.0:0.0)*float3(0.3, 0.4, 0.5);

    return float4(lerp(color, color2, gMeshShading), 1.0);
}



float4 wirePS(VS_OUTPUT In) : SV_TARGET0
{
    return float4(0.0, 0.0, 0.0, 1.0);
}


float4 celleveggPS(VS_OUTPUT In) : SV_TARGET0
{
    return float4(0.0, 0.0, 0.0, 0.3);
}



//--------------------------------------------------------------------------------------
// Techniques
//--------------------------------------------------------------------------------------


RasterizerState wireframeState
{
    CullMode = FRONT;
    FillMode = WIREFRAME;
//    FillMode = SOLID;
};

technique10 wireframe
{
    pass P0
    {
        SetBlendState(Blending_None, /*Blendfactor*/ float4(0.0, 0.0, 0.0, 0.0), /*Sample mask*/ 0xFFFFFFFF);
        SetDepthStencilState(Depth_Enable_No_Write, /*ref value*/ 0);
        SetRasterizerState(wireframeState);

		SetVertexShader(CompileShader(vs_4_0, wireframeVS()));
        SetGeometryShader(NULL);
        SetPixelShader(CompileShader(ps_4_0, wireframePS()));
    }
}





RasterizerState svabarState
{
    CullMode = BACK;
    FillMode = WIREFRAME;
};

technique10 smooth
{
    pass P0
    {
        SetBlendState(Blending_None, /*Blendfactor*/ float4(0.0, 0.0, 0.0, 0.0), /*Sample mask*/ 0xFFFFFFFF);
        SetDepthStencilState(Depth_Enable, /*ref value*/ 0);
        SetRasterizerState(Culling_Front);

		SetVertexShader(CompileShader(vs_4_0, VS()));
        SetGeometryShader(NULL);
        SetPixelShader(CompileShader(ps_4_0, PS()));
    }
    pass P1
    {
        SetBlendState(Blending_Alpha, /*Blendfactor*/ float4(0.0, 0.0, 0.0, 0.0), /*Sample mask*/ 0xFFFFFFFF);
        SetDepthStencilState(Depth_Enable_No_Write, /*ref value*/ 0);
        SetRasterizerState(Culling_Back);

        SetVertexShader(CompileShader(vs_4_0, DistortedVS()));
        SetGeometryShader(NULL);
        SetPixelShader(CompileShader(ps_4_0, celleveggPS()));
    }
    pass P2
    {
        SetBlendState(Blending_None, /*Blendfactor*/ float4(0.0, 0.0, 0.0, 0.0), /*Sample mask*/ 0xFFFFFFFF);
        SetDepthStencilState(Depth_Enable_No_Write, /*ref value*/ 0);
        SetRasterizerState(svabarState);

        SetVertexShader(CompileShader(vs_4_0, DistortedVS()));
        SetGeometryShader(NULL);
        SetPixelShader(CompileShader(ps_4_0, wirePS()));
    }
}

