#include "fw_Globals.fxi"		// shared stuff
#include "fw_States.fxi"		// standard fw_Effect states


//-----------------------------------------------------------------------------
// Textures
//-----------------------------------------------------------------------------


Texture2D gTexture;


SamplerState sampler1
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = WRAP;
    AddressV = WRAP;
};


//----------------------------------------------------------------------------
// Vertex input stream.
//----------------------------------------------------------------------------
struct VS_INPUT
{
    float3 position_animationOffset : POSITION0;
    float2 dim : TEXCOORD0;
};

struct VS_OUTPUT
{
    float4 position : SV_POSITION;
    float t : TEXCOORD0;
    float2 uv : TEXCOORD1;
};


//-----------------------------------------------------------------------------
// Shaders
//-----------------------------------------------------------------------------

// Motion-blurry time.
float gTime;

int gRndSeed;

float3 calcpos(
    float2 pos,
    float animationOffset,
    float time,
    out float anim)
{
    float3 positionModelSpace = float3(pos, 0.0f);
    // Rotata!
    // x \mapsto q*x*q^-1

    float duration = 3.0 + (animationOffset%1.0);
    float t = time % duration;
    t -= 0.25*duration;

    float drift = t >= 0.0 ? 
        -200.0*t*t*t*t :
        -0.0;

    anim = drift;

    float3 positionWorldSpace = positionModelSpace + float3(
        drift, 500.0f*(-0.5 + ((0.76*(float)gRndSeed*animationOffset) % 1.0)), 0.0);

    return positionWorldSpace;
}

float gQuadScale;

VS_OUTPUT
VS(VS_INPUT In)
{
    VS_OUTPUT Out;

    // Compute the world space coordinates.

    float2 dim = gQuadScale*In.dim;
    float2 pos = dim + In.position_animationOffset.xy;

    float3 positionWorldSpace = 
        calcpos(pos, In.position_animationOffset.z, (gTime + 20.0*In.position_animationOffset.z), Out.t);

    Out.position = mul(float4(positionWorldSpace, 1.0), ViewProjection);

    // UVs
    float dummy;
    float3 xxxx = 
        calcpos(pos, In.position_animationOffset.z, /* UVs from the neutral start position */0.0, dummy);
    float4 uvPos = mul(float4(xxxx, 1.0), ViewProjection);

    Out.uv = 0.5 + 0.5*float2(uvPos.x/uvPos.w, -uvPos.y/uvPos.w);
//    Out.uv.x += 0.62*gTime;

    return Out;
}


float4 
PS(VS_OUTPUT In) : SV_TARGET0
{
    float4 color = gTexture.Sample(sampler1, In.uv);
    return float4(0.8 * color.rgb, 0.02);
}


technique10 leafs
{
    pass P0
    {
//        SetBlendState(Blending_None, /*Blendfactor*/ float4(0.0, 0.0, 0.0, 0.0), /*Sample mask*/ 0xFFFFFFFF);
        SetBlendState(Blending_Alpha, /*Blendfactor*/ float4(0.0, 0.0, 0.0, 0.0), /*Sample mask*/ 0xFFFFFFFF);
//        SetBlendState(Blending_One_One, /*Blendfactor*/ float4(0.0, 0.0, 0.0, 0.0), /*Sample mask*/ 0xFFFFFFFF);
        SetDepthStencilState(Depth_Enable_No_Write, /*ref value*/ 0);
        SetRasterizerState(Culling_None);

        SetVertexShader(CompileShader(vs_4_0, VS()));
        SetGeometryShader(NULL);
        SetPixelShader(CompileShader(ps_4_0, PS()));
    }
}


