/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.opengl.util.AnimatorBase;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.media.opengl.GLAutoDrawable;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

class AWTAnimatorImpl
implements AnimatorBase.AnimatorImpl {
    private final List<JComponent> lightweights = new ArrayList<JComponent>();
    private final Map<RepaintManager, RepaintManager> repaintManagers = new IdentityHashMap<RepaintManager, RepaintManager>();
    private final Map<JComponent, Rectangle> dirtyRegions = new IdentityHashMap<JComponent, Rectangle>();
    private final Runnable drawWithRepaintManagerRunnable = new Runnable(){

        @Override
        public void run() {
            Object object;
            Object object2;
            for (JComponent jComponent : AWTAnimatorImpl.this.lightweights) {
                object2 = RepaintManager.currentManager(jComponent);
                ((RepaintManager)object2).markCompletelyDirty(jComponent);
                AWTAnimatorImpl.this.repaintManagers.put(object2, object2);
                object = jComponent.getVisibleRect();
                int n = ((Rectangle)object).x;
                int n2 = ((Rectangle)object).y;
                while (jComponent != null) {
                    n += jComponent.getX();
                    n2 += jComponent.getY();
                    Container container = jComponent.getParent();
                    if (container == null || !(container instanceof JComponent)) {
                        jComponent = null;
                        continue;
                    }
                    jComponent = (JComponent)container;
                    if (jComponent.isOptimizedDrawingEnabled()) continue;
                    object2 = RepaintManager.currentManager(jComponent);
                    AWTAnimatorImpl.this.repaintManagers.put(object2, object2);
                    Rectangle rectangle = (Rectangle)AWTAnimatorImpl.this.dirtyRegions.get(jComponent);
                    if (rectangle == null) {
                        rectangle = new Rectangle(n, n2, ((Rectangle)object).width, ((Rectangle)object).height);
                        AWTAnimatorImpl.this.dirtyRegions.put(jComponent, rectangle);
                        continue;
                    }
                    rectangle.add(new Rectangle(n, n2, ((Rectangle)object).width, ((Rectangle)object).height));
                }
            }
            for (JComponent jComponent : AWTAnimatorImpl.this.dirtyRegions.keySet()) {
                object2 = (Rectangle)AWTAnimatorImpl.this.dirtyRegions.get(jComponent);
                object = RepaintManager.currentManager(jComponent);
                ((RepaintManager)object).addDirtyRegion(jComponent, ((Rectangle)object2).x, ((Rectangle)object2).y, ((Rectangle)object2).width, ((Rectangle)object2).height);
            }
            Iterator<Object> iterator = AWTAnimatorImpl.this.repaintManagers.keySet().iterator();
            while (iterator.hasNext()) {
                ((RepaintManager)iterator.next()).paintDirtyRegions();
            }
            AWTAnimatorImpl.this.dirtyRegions.clear();
            AWTAnimatorImpl.this.repaintManagers.clear();
        }
    };

    AWTAnimatorImpl() {
    }

    @Override
    public void display(ArrayList<GLAutoDrawable> arrayList, boolean bl, boolean bl2) throws AnimatorBase.UncaughtAnimatorException {
        for (int i = 0; i < arrayList.size(); ++i) {
            GLAutoDrawable gLAutoDrawable = arrayList.get(i);
            if (gLAutoDrawable instanceof JComponent) {
                this.lightweights.add((JComponent)((Object)gLAutoDrawable));
                continue;
            }
            try {
                gLAutoDrawable.display();
                continue;
            }
            catch (Throwable throwable) {
                if (bl) {
                    if (!bl2) continue;
                    throwable.printStackTrace();
                    continue;
                }
                throw new AnimatorBase.UncaughtAnimatorException(gLAutoDrawable, throwable);
            }
        }
        if (this.lightweights.size() > 0) {
            try {
                SwingUtilities.invokeAndWait(this.drawWithRepaintManagerRunnable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.lightweights.clear();
        }
    }

    @Override
    public boolean blockUntilDone(Thread thread) {
        return Thread.currentThread() != thread && !EventQueue.isDispatchThread();
    }
}

