/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.example;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.gstreamer.ElementFactory;
import org.gstreamer.Gst;
import org.gstreamer.Pipeline;
import org.gstreamer.elements.PlayBin2;
import org.gstreamer.swing.VideoPlayer;

public class SwingMultiPlayerAlpha {
    public static void main(String[] args) {
        if ((args = Gst.init("Swing Player", args)).length < 1) {
            System.err.println("Usage: SwingPlayer <filename>");
            System.exit(1);
        }
        final File[] files = new File[args.length];
        for (int i = 0; i < args.length; ++i) {
            files[i] = new File(args[i]);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JFrame window = new JFrame("Swing Video Player");
                JDesktopPane panel = new JDesktopPane();
                window.add(panel);
                for (int i = files.length - 1; i >= 0; --i) {
                    File file = files[i];
                    JInternalFrame frame = new JInternalFrame(file.getName());
                    panel.add(frame);
                    frame.setResizable(true);
                    frame.setClosable(true);
                    frame.setIconifiable(true);
                    frame.setMaximizable(true);
                    frame.setLocation(i * 100, i * 100);
                    float alpha = 0.6f;
                    final VideoPlayer player = new VideoPlayer(file){
                        private static final long serialVersionUID = 4925431893247320169L;

                        protected void paintComponent(Graphics g) {
                            Graphics2D g2d = (Graphics2D)g.create();
                            g2d.setComposite(AlphaComposite.getInstance(3, 0.6f));
                            g2d.setColor(Color.BLACK);
                            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
                            g2d.dispose();
                        }
                    };
                    player.setPreferredSize(new Dimension(400, 250));
                    player.setControlsVisible(true);
                    player.setOpaque(false);
                    player.setOpacity(0.6f);
                    Pipeline pipe = player.getMediaPlayer().getPipeline();
                    if (pipe instanceof PlayBin2) {
                        ((PlayBin2)pipe).setAudioSink(ElementFactory.make("fakesink", "audio"));
                    }
                    frame.setOpaque(false);
                    frame.setContentPane(player);
                    frame.pack();
                    frame.setVisible(true);
                    Timer timer = new Timer(5000 * i, new ActionListener(){

                        public void actionPerformed(ActionEvent evt) {
                            player.getMediaPlayer().play();
                        }
                    });
                    timer.setRepeats(false);
                    timer.start();
                }
                window.setPreferredSize(new Dimension(1024, 768));
                window.setDefaultCloseOperation(3);
                window.pack();
                window.setVisible(true);
            }
        });
    }
}

