/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Config;
import com.sun.deploy.panel.CertificatesDialog;
import com.sun.deploy.panel.ExceptionListDialog;
import com.sun.deploy.panel.JSmartTextArea;
import com.sun.deploy.panel.RuleSetViewerDialog;
import com.sun.deploy.panel.SecurityLevelPanel;
import com.sun.deploy.panel.SecurityProperties;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.DeploySigningCertStore;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.FancyButton;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;

public class SecurityPanel
extends JPanel
implements SecurityProperties.JavaEnableListener {
    private JCheckBox enableBrowserCheckbox;
    private JLabel disabledForUserOnlyLabel;
    private JButton certsBtn;
    private Dimension exceptionListSize;
    private static final int SECURITY_LEVEL_TEXT_DESCRIPTION_COLUMNS = 40;

    public SecurityPanel() {
        this.initComponents();
        SecurityProperties.addJavaEnableListener(this);
    }

    public final void initComponents() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        Box box = Box.createVerticalBox();
        box.add(this.createEnableJavaInBrowser());
        box.add(this.createSecurityLevelPanel());
        box.add(this.createExceptionListPanel());
        if (DeploymentRuleSet.isRuleSetFileExists()) {
            box.add(this.createRuleSetViewerButtonPanel());
        }
        box.add(this.createCertificationPanel());
        Component component = Box.createVerticalStrut(5);
        box.add(component);
        component = Box.createVerticalStrut(new JLabel((String)"1").getPreferredSize().height * 5);
        box.add(component);
        this.add((Component)box, "North");
        this.enableBrowserCheckbox.setEnabled(!Config.get().isPropertyLocked("deployment.webjava.enabled"));
    }

    private void certsBtnActionPerformed(ActionEvent actionEvent) {
        CertificatesDialog certificatesDialog = new CertificatesDialog((Frame)((JFrame)this.getTopLevelAncestor()), true);
        certificatesDialog.setLocationRelativeTo(this);
        certificatesDialog.setVisible(true);
    }

    private void certsRestoreBtnActionPerformed(ActionEvent actionEvent) {
        boolean bl;
        int n = ToolkitStore.getUI().showMessageDialog(this.getTopLevelAncestor(), null, 2, ResourceManager.getString("cert.restore_dialog.title"), ResourceManager.getString("cert.restore_dialog.masthead"), ResourceManager.getString("cert.restore_dialog.message"), null, ResourceManager.getString("cert.restore_dialog.btn_restore.text"), ResourceManager.getString("cert.restore_dialog.btn_cancel.text"), null, null, null, 1);
        if (n == 0 && !(bl = this.restoreSecurityPrompt())) {
            this.showRestoringSecurityPromptFailDialog();
        }
    }

    private boolean restoreSecurityPrompt() {
        CertStore[] certStoreArray = new CertStore[]{DeploySigningCertStore.getUserCertStore(), DeploySigningCertStore.getSandboxCertStore()};
        boolean bl = true;
        for (int i = 0; i < certStoreArray.length; ++i) {
            bl = bl && this.clearCertStore(certStoreArray[i]);
        }
        bl = bl && Cache.removeRemeberedDecisions();
        return bl;
    }

    private boolean clearCertStore(CertStore certStore) {
        boolean bl = true;
        try {
            certStore.load(true);
            Collection collection = certStore.getCertificates();
            if (collection != null && collection.size() > 0) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    certStore.remove((Certificate)iterator.next());
                }
                certStore.save();
            }
        }
        catch (Exception exception) {
            Trace.ignored(exception);
            bl = false;
        }
        return bl;
    }

    private void showRestoringSecurityPromptFailDialog() {
        String string = ResourceManager.getString("common.ok_btn");
        String string2 = ResourceManager.getString("common.detail.button");
        ToolkitStore.getUI().showMessageDialog(this.getTopLevelAncestor(), null, 0, ResourceManager.getMessage("cert.restore_dialog.fail.caption"), ResourceManager.getMessage("cert.restore_dialog.fail.masthead"), ResourceManager.getMessage("cert.restore_dialog.fail.text"), null, string, string2, null);
    }

    private String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }

    private JPanel createSecurityLevelPanel() {
        return new SecurityLevelPanel();
    }

    private JPanel createRuleSetViewerButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        FancyButton fancyButton = new FancyButton(ResourceManager.getMessage("deployment.ruleset.view.button"), ResourceManager.getMnemonic("deployment.ruleset.view.button"), Color.BLUE);
        fancyButton.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SecurityPanel.this.showCurrentRuleSetDialog();
            }
        });
        jPanel.add((Component)fancyButton, "South");
        return jPanel;
    }

    private void showCurrentRuleSetDialog() {
        RuleSetViewerDialog ruleSetViewerDialog = new RuleSetViewerDialog((Frame)((JFrame)this.getTopLevelAncestor()), true);
        ruleSetViewerDialog.setLocationRelativeTo(this);
        ruleSetViewerDialog.setVisible(true);
    }

    private JPanel createExceptionListPanel() {
        final JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        Box box = Box.createVerticalBox();
        box.add(this.createLabel(0, "jcp.exception.list.label"));
        JSmartTextArea jSmartTextArea = new JSmartTextArea(this.getMessage("jcp.exception.list.text")){

            public Dimension getMinimumSize() {
                return super.getPreferredSize();
            }
        };
        jSmartTextArea.setBorder(new EmptyBorder(4, 24, 0, 0));
        jSmartTextArea.setColumns(45);
        box.add(jSmartTextArea);
        final JPanel jPanel2 = new JPanel(){

            public Dimension getMinimumSize() {
                return super.getPreferredSize();
            }
        };
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        this.fillExceptionList(jPanel2);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add(jPanel2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        String string = "jcp.exception.list.manage.btn";
        JButton jButton = new JButton(this.getMessage(string)){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                if (SecurityPanel.this.certsBtn != null) {
                    Dimension dimension2 = SecurityPanel.this.certsBtn.getPreferredSize();
                    dimension.width = Math.max(dimension.width, dimension2.width);
                }
                return dimension;
            }
        };
        final JFrame jFrame = (JFrame)this.getTopLevelAncestor();
        jButton.setMnemonic(ResourceManager.getMnemonic(string));
        jButton.setToolTipText(this.getMessage(string + ".tooltip"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExceptionListDialog exceptionListDialog = new ExceptionListDialog((Frame)jFrame, true);
                exceptionListDialog.setLocationRelativeTo(jFrame);
                exceptionListDialog.setVisible(true);
                SecurityPanel.this.fillExceptionList(jPanel2);
                jPanel2.invalidate();
                jPanel.invalidate();
                jPanel.validate();
            }
        });
        jPanel4.add((Component)jButton, "South");
        jPanel4.setBorder(new EmptyBorder(0, 0, 6, 5));
        jPanel3.add((Component)jPanel4, "After");
        jPanel3.setBorder(new EmptyBorder(0, 0, 16, 0));
        box.add(jPanel3);
        jPanel.add(box);
        return jPanel;
    }

    private JComponent createLabel(int n, String string) {
        Box box = Box.createHorizontalBox();
        JLabel jLabel = new JLabel(this.getMessage(string));
        box.add(Box.createRigidArea(new Dimension(10, jLabel.getPreferredSize().height)));
        jLabel.setBorder(new EmptyBorder(0, n, 0, 0));
        box.add(jLabel);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    private void fillExceptionList(JPanel jPanel) {
        boolean bl;
        jPanel.removeAll();
        Object[] objectArray = Config.getExceptionSites();
        JScrollPane jScrollPane = new JScrollPane();
        int n = 22;
        boolean bl2 = bl = objectArray.length == 0;
        if (bl) {
            n = 21;
            objectArray = this.getEmptyListPrompt();
        }
        JList jList = new JList(objectArray){

            public Dimension getPreferredSize() {
                Serializable serializable;
                if (SecurityPanel.this.exceptionListSize == null) {
                    if (!bl) {
                        serializable = new JList<String>(SecurityPanel.this.getEmptyListPrompt());
                        SecurityPanel.this.exceptionListSize = ((JComponent)serializable).getPreferredSize();
                    } else {
                        SecurityPanel.this.exceptionListSize = super.getPreferredSize();
                        return SecurityPanel.this.exceptionListSize;
                    }
                }
                serializable = super.getPreferredSize();
                ((Dimension)serializable).width = ((SecurityPanel)SecurityPanel.this).exceptionListSize.width;
                return serializable;
            }
        };
        jList.setCellRenderer(new MyCellRenderer());
        jList.setVisibleRowCount(3);
        jList.setLayoutOrientation(0);
        if (bl) {
            jList.setForeground(Color.GRAY);
        }
        jScrollPane.setViewportView(jList);
        jScrollPane.setVerticalScrollBarPolicy(n);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jPanel.setBorder(new EmptyBorder(0, 20, 0, 10));
        jPanel.add(jScrollPane);
    }

    private String[] getEmptyListPrompt() {
        return new String[]{this.getMessage("jcp.exception.list.empty1"), this.getMessage("jcp.exception.list.empty2")};
    }

    private JPanel createCertificationPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(this.getMessage("security.certificates.restore_button.text"));
        jButton.setMnemonic(ResourceManager.getMnemonic("security.certificates.restore_button.text"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SecurityPanel.this.certsRestoreBtnActionPerformed(actionEvent);
            }
        });
        jButton.setToolTipText(this.getMessage("security.certs_restore_btn.tooltip"));
        jPanel2.add(jButton);
        this.certsBtn = new JButton(this.getMessage("security.certificates.button.text"));
        this.certsBtn.setMnemonic(ResourceManager.getMnemonic("security.certificates.button.text"));
        this.certsBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SecurityPanel.this.certsBtnActionPerformed(actionEvent);
            }
        });
        this.certsBtn.setToolTipText(this.getMessage("security.certs_btn.tooltip"));
        jPanel2.add(this.certsBtn);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    private void decreaseFont(JComponent jComponent, int n) {
        Font font = jComponent.getFont();
        jComponent.setFont(new Font(font.getName(), font.getStyle(), font.getSize() - n));
    }

    private JComponent createEnableJavaInBrowser() {
        Box box = Box.createHorizontalBox();
        this.enableBrowserCheckbox = new JCheckBox(ResourceManager.getMessage("deployment.security.enable.java.browser"));
        this.enableBrowserCheckbox.setMnemonic(ResourceManager.getAcceleratorKey("deployment.security.enable.java.browser"));
        this.enableBrowserCheckbox.setSelected(SecurityProperties.isJavaInBrowserEnabled());
        this.enableBrowserCheckbox.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = SecurityPanel.this.enableBrowserCheckbox.isSelected();
                SecurityProperties.enableJavaInBrowser(bl);
                SecurityPanel.this.setTextForUserDisabledLabel();
            }
        });
        box.add(this.enableBrowserCheckbox);
        this.disabledForUserOnlyLabel = new JLabel("");
        this.decreaseFont(this.disabledForUserOnlyLabel, 2);
        this.setTextForUserDisabledLabel();
        box.add(this.disabledForUserOnlyLabel);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    private void setTextForUserDisabledLabel() {
        if (SecurityProperties.isJavaInBrowserDisabledForUser()) {
            this.disabledForUserOnlyLabel.setText(ResourceManager.getMessage("deployment.security.java.browser.user.disabled"));
        } else {
            this.disabledForUserOnlyLabel.setText("");
        }
    }

    public void javaEnableChanged(SecurityProperties.JavaEnableEvent javaEnableEvent) {
        this.setTextForUserDisabledLabel();
        this.enableBrowserCheckbox.setSelected(javaEnableEvent.isEnabled());
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        MyCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = object.toString();
            this.setText(string);
            this.setBackground(jList.getBackground());
            this.setForeground(jList.getForeground());
            this.setEnabled(true);
            this.setFont(jList.getFont());
            this.setOpaque(true);
            return this;
        }
    }
}

