#version 150
#extension GL_ARB_explicit_attrib_location : require
#extension GL_ARB_draw_instanced : require

uniform mat4 viewProjection;

layout(location = 0) in vec3 in_position;
layout(location = 1) in vec3 in_normal;
layout(location = 2) in mat4 in_world;
layout(location = 6) in mat4 in_worldInverseTranspose;

out vec3 normal;
out vec3 worldPosition;

void main()
{
	mat4 worldViewProjection = viewProjection * in_world;

	normal = normalize((in_worldInverseTranspose * vec4(in_normal, 0.0)).xyz);

	gl_Position = worldViewProjection * vec4(in_position, 1.0);

	vec4 tempPosition = in_world * vec4(in_position, 1.0);
	worldPosition = tempPosition.xyz / tempPosition.w;
}
