#version 150

in vec3 normal;
in vec3 worldPosition;
out vec4 color;
uniform vec3 cubeColor = vec3(0.5457244613701866, 0.6795424696330938, 1.0);

void main()
{
	vec3 l = normalize(vec3(10.0, 5.0, 0.0) - worldPosition);

	float diffuse = dot(normalize(normal), l);
	diffuse = clamp(diffuse, 0.0, 1.0);
	diffuse = diffuse * 0.95 + 0.05;

	color = vec4(cubeColor * diffuse, 1.0);
}
