#version 150

uniform sampler2D tex;
uniform float height;

in vec2 uv;
out vec4 color;

uniform float offset[3] = float[]( 0.0, 1.3846153846, 3.2307692308 );
uniform float weight[3] = float[]( 0.2270270270, 0.3162162162, 0.0702702703 );

void main()
{
	color = texture(tex, uv) * weight[0];

	for(int i = 1; i < 3; i++) {
		color += texture(tex, uv + vec2(0, offset[i] / height)) * weight[i];
		color += texture(tex, uv - vec2(0, offset[i] / height)) * weight[i];
	}

	color *= 1.2;
}
