#version 120

#define M_PI 3.1415926535897932384626433832795
#define TWIRL 1
#define TUNNEL 2
#define FLOWER 3
#define FANCY 4
#define RIPPLE 5
#define MILD_TWIRL 6
#define WALLS 7
#define HARD_FLOWER 8

uniform sampler2D texture;
uniform int effect = TWIRL;
uniform float time = 1.0;
uniform float fade = 0.0;
uniform float texCoordS = 1.0;
uniform float texCoordT = 1.0;

void main()
{
	vec2 coord=gl_TexCoord[0].xy;
	float x = (-1.0 + 2.0 * coord.x);
	float y = (-1.0 + 2.0 * coord.y);
	float u = sqrt( x*x + y*y );
	float v = atan( y, x );

	if (effect == TWIRL)
	{
		coord.x = x*cos(2*u) - y*sin(2*u);
		coord.y = y*cos(2*u) + x*sin(2*u);
	}
	else if (effect == TUNNEL)
	{
		coord.x = cos( v )/u;
		coord.y = sin( v )/u;
	}
	else if (effect == FLOWER)
	{
		coord.x = u;
		coord.y = v;
	}
	else if (effect == FANCY)
	{
		coord.x = 0.02*y+0.03*cos(v*3)/u;
		coord.y = 0.02*x+0.03*sin(v*3)/u;
	}
	else if (effect == RIPPLE)
	{
		coord.x = 0.5*v/M_PI;
		coord.y = sin(7*u);
	}
	else if (effect == MILD_TWIRL)
	{
		coord.x = u*cos(v+u);
		coord.y = u*sin(v+u);
	}
	else if (effect == WALLS)
	{
		coord.x = x/abs(y);
		coord.y = 1/abs(y);
	}
	else if (effect == HARD_FLOWER)
	{
		coord.x = 1/(u+0.5+0.5*sin(5*v));
		coord.y = v*3/M_PI;
	}
	coord.x *= texCoordS;
	coord.y *= texCoordT;
    vec4 uv = texture2D( texture, coord + vec2(time) );
    gl_FragColor = uv + fade/u;
}
