var scriptJson = readFile('data/js/script.json');
var demoScript = JSON.parse(scriptJson);

setPlaylistMusic(demoScript.music);
setPlaylistLength(demoScript.totalTime);

if (demoScript.screen !== undefined)
{
	setScreenDimensions(demoScript.screen.width, demoScript.screen.height);

	if (demoScript.screen.aspectRatio !== undefined)
	{
		setWindowScreenAreaAspectRatio(demoScript.screen.aspectRatio.width, demoScript.screen.aspectRatio.height);
	}
	else
	{
		setWindowScreenAreaAspectRatio(demoScript.screen.width, demoScript.screen.height);
	}
}

if (demoScript.window !== undefined)
{
	if (demoScript.window.title !== undefined)
	{
		windowSetTitle(demoScript.window.title);
	}
}

if (demoScript.clearColor !== undefined)
{
	setClearColor(demoScript.clearColor.r, demoScript.clearColor.g, demoScript.clearColor.b, demoScript.clearColor.a);
}

if (demoScript.resolutions !== undefined)
{
	for (var i = 0; i < demoScript.resolutions.length; i++)
	{
		setMenuResolution(i, demoScript.resolutions[i].width + "x" + demoScript.resolutions[i].height);
		
		if (demoScript.resolutions[i].default === true)
		{
			setMenuComponentSelected(i);
		}
	}
}
