/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.kananen.miska.emissions;

import com.gmail.kananen.miska.emissions.Emissions;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerRespawnListener
implements Listener {
    Emissions plugin;
    private ArrayList<Player> invulnQueue = new ArrayList();

    public PlayerRespawnListener(Emissions plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent e) {
        Location bedLoc = e.getPlayer().getBedSpawnLocation();
        if (bedLoc != null && this.plugin.cover.isInCover(bedLoc)) {
            return;
        }
        if (this.plugin.safeAreas.size() != 0) {
            double shortestDistance = e.getPlayer().getLocation().distance(this.plugin.getCenter(this.plugin.safeAreas.get(0)));
            int shortestIndex = 0;
            int i = 0;
            while (i < this.plugin.safeAreas.size()) {
                double distance = e.getPlayer().getLocation().distance(this.plugin.getCenter(this.plugin.safeAreas.get(i)));
                if (distance < shortestDistance) {
                    shortestDistance = distance;
                    shortestIndex = i;
                }
                ++i;
            }
            Object[] spawnPosData = this.plugin.getUnobstructedPosInArea(this.plugin.safeAreas.get(shortestIndex));
            Location spawnPos = (Location)spawnPosData[0];
            boolean foundInArea = (Boolean)spawnPosData[1];
            if (foundInArea) {
                e.setRespawnLocation(spawnPos);
                this.plugin.sendMessage(e.getPlayer(), "Normal spawnpoint is dangerous, spawned in cover.");
                this.invulnQueue.add(e.getPlayer());
                new BukkitRunnable(){

                    public void run() {
                        PlayerRespawnListener.this.addInvulnerabilityPotionEffects(150);
                    }
                }.runTaskLater((Plugin)this.plugin, 2L);
            } else {
                e.setRespawnLocation(spawnPos);
                this.invulnQueue.add(e.getPlayer());
                new BukkitRunnable(){

                    public void run() {
                        PlayerRespawnListener.this.addInvulnerabilityPotionEffects(300);
                    }
                }.runTaskLater((Plugin)this.plugin, 2L);
                this.plugin.sendMessage(e.getPlayer(), "Normal spawnpoint is dangerous and closest safe area was obstructed.");
                this.plugin.sendMessage(e.getPlayer(), "15 second invulnerability applied, get to cover!");
            }
        } else {
            new BukkitRunnable(){

                public void run() {
                    PlayerRespawnListener.this.addInvulnerabilityPotionEffects(300);
                }
            }.runTaskLater((Plugin)this.plugin, 2L);
            this.plugin.sendMessage(e.getPlayer(), "Normal spawnpoint is dangerous and there are no safe areas defined.");
            this.plugin.sendMessage(e.getPlayer(), "15 second invulnerability applied, get to cover!");
            this.invulnQueue.add(e.getPlayer());
        }
    }

    public void addInvulnerabilityPotionEffects(int durationTicks) {
        for (Player p : this.invulnQueue) {
            p.addPotionEffect(new PotionEffect(PotionEffectType.HEAL, durationTicks, 10, true), true);
            p.addPotionEffect(new PotionEffect(PotionEffectType.HEALTH_BOOST, durationTicks, 9, true), true);
        }
        this.invulnQueue.clear();
    }
}

