/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.kananen.miska.emissions;

import com.gmail.kananen.miska.emissions.Emissions;
import org.bukkit.Location;
import org.bukkit.scheduler.BukkitRunnable;

public class BlastWaveTask
extends BukkitRunnable {
    private Emissions plugin;
    private Location effectCenter;
    private Location effectEndingPoint;
    private int waveWidth;
    private float waveSize;
    private int waveSpeed;
    private int RANDOMNESS_AMOUNT = 3;
    private int ignitionChance;

    public BlastWaveTask(Emissions plugin, Location effectCenter, int startBlocksAwayFromCenter, int waveWidth, float waveSize, int waveSpeed, int ignitionChance) {
        this.plugin = plugin;
        this.effectCenter = new Location(effectCenter.getWorld(), effectCenter.getX() + (double)startBlocksAwayFromCenter, effectCenter.getY(), effectCenter.getZ());
        this.effectEndingPoint = new Location(effectCenter.getWorld(), effectCenter.getX() - (double)startBlocksAwayFromCenter, effectCenter.getY(), effectCenter.getZ());
        this.waveWidth = waveWidth;
        this.waveSize = waveSize;
        this.waveSpeed = waveSpeed;
        this.ignitionChance = ignitionChance;
    }

    public void run() {
        this.effectCenter.setX(this.effectCenter.getX() - (double)this.waveSpeed);
        if (this.effectCenter.getX() < this.effectEndingPoint.getX()) {
            this.cancel();
        }
        int i = -this.waveWidth;
        while (i < this.waveWidth) {
            Location l = this.randomizeLocation(this.getHighestYLocation(new Location(this.effectCenter.getWorld(), this.effectCenter.getX(), this.effectCenter.getY(), this.effectCenter.getZ() + (double)i), 2), this.RANDOMNESS_AMOUNT);
            this.plugin.currentWorld.createExplosion(l.getX(), l.getY(), l.getZ(), this.waveSize, this.plugin.nextRandomInt(0, 1000) < this.ignitionChance, false);
            i += 3;
        }
    }

    private Location getHighestYLocation(Location loc, int yHeightAdjust) {
        return new Location(loc.getWorld(), loc.getX(), (double)(this.plugin.currentWorld.getHighestBlockYAt(loc) + yHeightAdjust), loc.getZ());
    }

    private Location randomizeLocation(Location loc, int amount) {
        return new Location(loc.getWorld(), loc.getX() + (double)this.getRandomInt(amount), loc.getY() + (double)this.getRandomInt(amount), loc.getZ() + (double)this.getRandomInt(amount));
    }

    private int getRandomInt(int max) {
        return this.plugin.nextRandomInt(-max, max);
    }
}

